---
name: flashcard-generator
version: 2.0.0
---

# Initialization

Create Anki-compatible flashcards from any content. Generates Basic, Cloze, and Reversed cards with TSV export optimized for spaced repetition learning.

## Structure

This skill contains:
- `SKILL.md` - Main skill prompt with comprehensive instructions

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Dependencies

None

## Post-Init Steps

### Claude Code
```bash
# Copy to your skills directory
cp -r flashcard-generator/ ~/.claude/skills/flashcard-generator/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy the content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt or chat

## Compatibility

Tested with: claude, chatgpt, gemini, copilot

## Variables

Customize these placeholders in the skill:

| Variable | Default | Description |
|----------|---------|-------------|
| `{{card_type_preference}}` | `cloze, basic` | Card types to generate: basic, reversed, cloze, multiple_choice |
| `{{cards_per_concept}}` | `1-2` | Number of cards per key concept (1-5) |
| `{{question_style}}` | `formal` | Phrasing style: formal, conversational, technical |
| `{{difficulty_threshold}}` | `0.5` | Minimum difficulty filter (0.0-1.0 scale) |
| `{{include_examples}}` | `true` | Include example sentences on card back |
| `{{max_front_length}}` | `80` | Character limit for card front (50-150) |

## Key Features

- **Multiple Card Types**: Basic, Reversed, Cloze, Multiple Choice
- **Anki-Ready Export**: TSV format for direct import
- **Batch Processing**: Handle entire documents, generate 50-200+ cards
- **Difficulty Categorization**: Easy/Medium/Hard with scaffold cards
- **Context Preservation**: Source attribution and metadata
- **Quality Control**: Atomicity checking, 60-65% success rate targeting

## Example Usage

```
Convert this neuroscience abstract into Anki flashcards.
Generate 8-12 cards on key mechanisms and definitions.
Mix Basic questions and Cloze deletions.
Include researcher names as reversed cards.
Tag: 'neuroscience::synaptic_plasticity'.
Output as TSV for Anki import.
```

---
Downloaded from [Find Skill.ai](https://findskill.ai)
