---
name: freelance-income-tracker
version: 1.0.0
---

# Initialization

Track client payments, outstanding invoices, and project income for freelancers and self-employed professionals. Monitor cash flow and prepare for taxes.

## Structure

This skill contains:
- `SKILL.md` - Main skill prompt with instructions

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Dependencies

None

## Post-Init Steps

### Claude Code
```bash
# Copy to your skills directory
cp -r freelance-income-tracker/ ~/.claude/skills/freelance-income-tracker/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy the content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt or chat

## Compatibility

Tested with: claude, chatgpt, gemini, copilot

## Variables

Customize these placeholders in the skill:

| Variable | Default | Description |
|----------|---------|-------------|
| `{{tax_rate}}` | `25%` | Estimated self-employment tax rate |
| `{{payment_terms}}` | `Net 30` | Standard invoice payment terms |
| `{{tracking_period}}` | `monthly` | Time period for income tracking |
| `{{mileage_rate}}` | `$0.70/mile` | IRS standard mileage rate |

---
Downloaded from [Find Skill.ai](https://findskill.ai)