---
name: freelance-rate-calculator
version: 1.0.0
---

# Freelance Rate Calculator - Initialization

Calculate your true freelance hourly rate by accounting for taxes, insurance, overhead costs, and non-billable time. This skill reveals why sustainable freelance rates are typically 2-4x higher than initial expectations.

## Structure

```
freelance-rate-calculator/
├── SKILL.md     # Main skill prompt (copy to AI assistant)
└── INIT.md      # This initialization file
```

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Claude Code

```bash
# Copy to Claude Code skills directory
cp -r freelance-rate-calculator/ ~/.claude/skills/freelance-rate-calculator/
```

Then reference in your prompts or add to Claude settings.

### ChatGPT / GPT-4

1. Open `SKILL.md`
2. Copy all content after the frontmatter (starting with "You are an expert...")
3. Paste into ChatGPT as your first message or create a Custom GPT

### Claude.ai (Web)

1. Open `SKILL.md`
2. Copy all content after the frontmatter
3. Paste into a new conversation or add to your Project Knowledge

### Gemini

1. Open `SKILL.md`
2. Copy all content after the frontmatter
3. Paste as system instructions or initial prompt

### Copilot

1. Open `SKILL.md`
2. Copy all content after the frontmatter
3. Paste into conversation as context

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{desired_annual_income}}` | `$50,000` | Target net income after taxes and expenses |
| `{{annual_expenses}}` | `$5,000` | Total yearly business costs (software, insurance, equipment) |
| `{{tax_rate_percentage}}` | `35%` | Combined tax burden (federal + state + self-employment) |
| `{{billable_hours_per_year}}` | `1200` | Realistic billable hours accounting for non-billable time |
| `{{profit_margin_percentage}}` | `20%` | Desired profit buffer beyond break-even |
| `{{expense_multiplier}}` | `1.5` | Buffer for scope creep and unexpected costs |

## Core Formulas

### Basic Rate Calculation
```
Hourly Rate = (Desired Income + Expenses) / (1 - Tax Rate) / Billable Hours
```

### Salary Conversion
```
Freelance Rate = (Salary + Benefits) / 2000 hours x Multiplier (2.5-4x)
```

### Break-Even Rate
```
Break-Even = (Fixed Costs + Living Expenses) / (1 - Tax Rate) / Billable Hours
```

### Project Pricing
```
Project Price = Estimated Hours x Hourly Rate x Buffer (1.5-2x)
```

## Quick Start Examples

### Example 1: New Freelancer
"I want to earn $60,000/year net, have $5,000 in business expenses, and can bill 25 hours/week. What's my rate?"

### Example 2: Salary Conversion
"I make $80,000 as an employee with 30% benefits. What should I charge as a freelancer?"

### Example 3: Project Quote
"I need to quote a website redesign. My rate is $85/hour and I estimate 40 hours of work."

### Example 4: Break-Even Analysis
"What's my minimum rate to cover $4,000/month in living expenses plus $400/month business costs?"

## Key Insights

1. **Self-Employment Tax**: 15.3% on top of income tax (employees only pay half)
2. **Billable Hours**: Typically 1,000-1,500/year, NOT 2,000 (50% chargeability)
3. **Multiplier Rule**: Freelance rate = 2.5-4x employee hourly equivalent
4. **Tax Reserve**: Set aside 30-35% of every payment for taxes

## Verification

After setup, test with this prompt:

"Calculate my freelance rate. I want $50,000 net income, have $5,000 in annual expenses, pay 35% total taxes, and can bill 1,200 hours per year."

Expected output should show approximately $85/hour rate with full breakdown.

---
Downloaded from [Find Skill.ai](https://findskill.ai)
