---
name: fridge-recipe-finder
version: 1.0.0
description: Transform available pantry ingredients into complete recipes with step-by-step instructions, nutritional info, and substitution suggestions
author: FindSkill.ai
license: MIT
---

# Initialization

An ingredient-based recipe finder that transforms random fridge and pantry contents into delicious meals. Specializes in reducing food waste by using what you already have, with smart substitution suggestions.

## Overview

This is a prompt-only skill. Simply copy the content from SKILL.md and paste it into your AI assistant.

**Time to initialize**: ~1 minute

## Directory Structure

```
fridge-recipe-finder/
├── SKILL.md    # Main skill instructions (copy this)
└── INIT.md     # This initialization file
```

## Dependencies

None - this is a prompt-only skill.

## Files to Generate

None - all content is in SKILL.md.

## Post-Init Steps

### Claude Code
```bash
# Copy to your skills directory
cp -r fridge-recipe-finder/ ~/.claude/skills/fridge-recipe-finder/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy the content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt or chat

## Compatibility

Tested with: Claude, ChatGPT, Gemini, Copilot

## Variables

Customize these placeholders in the skill:

| Variable | Default | Description |
|----------|---------|-------------|
| `{{cooking_skill}}` | `intermediate` | User's cooking skill level |
| `{{time_available}}` | `30 minutes` | How much time to cook |
| `{{servings_needed}}` | `4` | Number of servings required |
| `{{dietary_preferences}}` | `none` | Any dietary restrictions |

## Key Features

### Ingredient-Based Recipe Discovery
- Input whatever you have on hand
- Get ranked recipe options by ingredient match
- Prioritize expiring ingredients

### Smart Substitutions
- Comprehensive substitution tables for proteins, dairy, vegetables, pantry items
- Notes on how substitutions affect the final dish
- Ratio guidance for accurate swaps

### Complete Recipes
- Step-by-step cooking instructions
- Prep time, cook time, and difficulty
- Nutritional information per serving
- Storage and reheating guidance

### Food Waste Prevention
- Prioritization based on expiration
- Ingredient revival tips (wilted greens, stale bread)
- Freezer storage strategies

## Example Usage

```
I have chicken thighs (about 1 lb), rice, canned black beans, half an onion, garlic, lime, and some wilting cilantro. I also have basic pantry stuff like oil, salt, and spices. What can I make in about 30 minutes for 4 people? I don't want anything too spicy.
```

## Supported Cuisines

The skill can suggest recipes from various cuisines:
- American comfort food
- Mexican/Tex-Mex
- Asian stir-fries and rice bowls
- Italian pasta dishes
- Mediterranean bowls
- Simple breakfasts

---
Downloaded from [Find Skill.ai](https://findskill.ai)
