---
name: geographic-expansion-prompt
version: 1.0.0
---

# Initialization

Geographic Expansion Prompt - Systematically analyze geographic market entry feasibility with PESTEL, competitive analysis, entry mode selection, and financial modeling.

## Structure

- `SKILL.md` - Main skill prompt with complete geographic expansion analysis framework

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Claude Code
```bash
cp -r geographic-expansion-prompt/ ~/.claude/skills/geographic-expansion-prompt/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after frontmatter
3. Paste into AI assistant

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{target_markets}}` | `United Kingdom, Germany, Canada` | Geographic markets under consideration |
| `{{analysis_depth}}` | `standard_assessment` | Scope: quick_screening, standard_assessment, comprehensive_analysis |
| `{{entry_mode_preference}}` | `export, licensing, joint_venture` | Entry strategies to evaluate |
| `{{risk_tolerance}}` | `moderate` | Risk appetite: conservative, moderate, aggressive |
| `{{localization_requirements}}` | `moderate` | Adaptation level: minimal, moderate, extensive |
| `{{investment_budget}}` | `$1,000,000` | Available capital for expansion |

## Core Capabilities

1. **Market Attractiveness Assessment** - Score markets on size, growth, profitability, competition, strategic fit
2. **PESTEL Analysis** - Comprehensive Political, Economic, Social, Technological, Environmental, Legal analysis
3. **Competitive Landscape Mapping** - Identify competitors, market gaps, positioning opportunities
4. **Entry Mode Selection** - Compare export, licensing, JV, subsidiary, FDI options
5. **Risk Assessment & Mitigation** - Identify, prioritize, and plan for expansion risks
6. **Financial Feasibility Analysis** - Investment requirements, revenue projections, break-even analysis
7. **Localization Strategy** - Product, pricing, marketing, and operations adaptation

## Analysis Workflows

1. **Market Screening** - Initial evaluation of 10-15 candidate markets
2. **Detailed Feasibility** - In-depth analysis of priority markets with go/no-go recommendation
3. **Entry Mode Selection** - Systematic comparison of entry strategies
4. **Go-to-Market Planning** - 12-18 month execution plan with milestones
5. **Risk & Contingency** - Risk register with mitigation strategies

## Example Usage

```
We're a $10M ARR B2B SaaS company in North America. Evaluate Thailand,
Vietnam, and Indonesia for expansion with a $500K budget. Analyze market
size, competitive landscape, localization needs, recommend entry mode,
create financial projections, and identify key risks with mitigation strategies.
```

---
Downloaded from [Find Skill.ai](https://findskill.ai)
