---
name: go-to-market-strategy-creator
version: 1.0.0
---

# Initialization

Expert Go-To-Market (GTM) strategist skill that helps users design comprehensive product launch strategies. Covers the complete 7-phase GTM framework: market research, customer segmentation, positioning, pricing, channel strategy, sales enablement, and launch execution planning.

## Structure

This skill contains:
- `SKILL.md` - Main skill prompt with complete GTM frameworks, templates, and interactive guidance

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Dependencies

None

## Post-Init Steps

### Claude Code
```bash
cp -r go-to-market-strategy-creator/ ~/.claude/skills/go-to-market-strategy-creator/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after the frontmatter (starting from "You are an expert Go-To-Market...")
3. Paste into your AI assistant's system prompt or custom instructions

## Compatibility

Tested with: claude, chatgpt, gemini, copilot

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{product_type}}` | `SaaS` | Type of product being launched (SaaS, Hardware, Service, Consumer App, B2B Enterprise) |
| `{{target_market}}` | `SMB` | Primary market segment (Enterprise, SMB, Startup, Individual Consumer) |
| `{{launch_timeframe}}` | `3 months` | Time available before launch (rapid <6 weeks, standard 2-3 months, extended >6 months) |
| `{{budget_level}}` | `Growth-stage` | Budget availability (Bootstrap $5-20K, Early-stage $50-100K, Growth-stage $200K+) |
| `{{competitive_intensity}}` | `moderate` | Market competition level (emerging market, moderate, highly-competitive) |
| `{{go_to_market_model}}` | `sales-led` | Primary GTM approach (sales-led, product-led, partnership-led, community-led) |

## Core Capabilities

This skill provides:

1. **Market Research & Analysis**
   - TAM/SAM/SOM market sizing calculations
   - Competitive landscape analysis frameworks
   - Market trends and dynamics assessment

2. **Customer Segmentation & Targeting**
   - B2B and B2C segmentation criteria
   - Segment prioritization matrix
   - ICP and buyer persona templates

3. **Positioning & Messaging**
   - Geoffrey Moore positioning framework
   - Value proposition canvas
   - Messaging hierarchy structure
   - Competitive differentiation strategies

4. **Pricing & Packaging Strategy**
   - Pricing model selection guidance
   - Pricing research methods
   - 3-tier package structure templates

5. **Channel & Distribution Strategy**
   - GTM model selection (sales-led, PLG, partnership-led, community-led)
   - Channel mix planning
   - Customer journey mapping

6. **Sales Enablement**
   - Sales process design
   - Collateral development checklist
   - Training program outline
   - Metrics dashboard

7. **Launch Execution**
   - Pre-launch, launch day, post-launch checklists
   - Launch metrics and KPIs
   - Troubleshooting common issues

## Example Usage

```
Create a comprehensive go-to-market strategy for my project management SaaS
targeting SMBs with 10-50 employees. We have $150K budget, plan to launch
in 10 weeks, and compete against Monday.com and Asana. Focus on a product-led
growth approach with freemium model.
```

## Related Skills

- [Competitive Analysis Framework](/skills/productivity/competitive-analysis/) - SWOT and Porter's Five Forces
- [Pricing Strategy Analyzer](/skills/productivity/pricing-strategy-analyzer/) - Optimal pricing models
- [Customer Journey Mapper](/skills/productivity/customer-journey-mapper/) - Touchpoint mapping
- [Business Plan Generator](/skills/productivity/business-plan-generator/) - Overall business planning
- [Pitch Deck Creator](/skills/productivity/pitch-deck-creator/) - Investor presentations
- [SaaS Idea Validator](/skills/productivity/saas-validator/) - Product-market fit validation

---
Downloaded from [Find Skill.ai](https://findskill.ai)
