---
name: grief-loss-processing-guide
version: 1.0.0
---

# Initialization

Navigate major life transitions (breakup, job loss, relocation, health change) with structured reflection using evidence-based grief frameworks including Worden's Four Tasks, Dual Process Model, and meaning reconstruction approaches.

## Structure

This skill contains:
- `SKILL.md` - Main skill prompt with comprehensive grief processing instructions

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Dependencies

None

## Post-Init Steps

### Claude Code
```bash
cp -r grief-loss-processing-guide/ ~/.claude/skills/grief-loss-processing-guide/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after the frontmatter (starting from "You are an expert grief and loss processing companion...")
3. Paste into your AI assistant

## Compatibility

Tested with: claude, chatgpt, gemini, copilot

## Core Frameworks Included

| Framework | Purpose |
|-----------|---------|
| Worden's Four Tasks | Structured mourning work: accept reality, process emotion, adjust, find connection |
| Dual Process Model | Balance loss-oriented (feeling) and restoration-oriented (rebuilding) coping |
| Five-Dimensional Model | Address physical, emotional, cognitive, social, spiritual grief dimensions |
| Continuing Bonds | Maintain transformed relationship through memory and values integration |
| Meaning Reconstruction | Reframe loss within life narrative for coherence and growth |

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{loss_type}}` | `comprehensive` | Type of loss (death, breakup, job_loss, relocation, health_change, identity_transition) |
| `{{processing_stage}}` | `beginning` | Where in grief journey (beginning, middle, integration, ongoing_triggers) |
| `{{reflection_depth}}` | `moderate` | Intensity level (light, moderate, deep) |
| `{{grief_dimension_focus}}` | `balanced` | Target area (physical, emotional, cognitive, social, spiritual, balanced) |
| `{{time_investment}}` | `15_minutes` | Available time (5_minutes, 15_minutes, 30_minutes, 60_minutes) |
| `{{cultural_framework}}` | `western_psychological` | Meaning-making approach (western_psychological, spiritual, religious, eastern_philosophy) |

## Supported Loss Types

- **Death/Bereavement** - Loss of loved ones
- **Breakup/Divorce** - Relationship endings
- **Job Loss** - Career transitions and layoffs
- **Relocation** - Geographic and community changes
- **Health Change** - Chronic illness diagnosis, disability
- **Identity Transition** - Role changes, retirement, empty nest
- **Non-Death Interpersonal Loss** - Personality changes in living person (dementia, addiction)

## Quick Reference: Workflows

| Workflow | Time | Best For |
|----------|------|----------|
| Quick Grounding | 5 min | Acute grief surges, triggered moments |
| Daily Reflection | 15 min | Regular processing, maintaining balance |
| Deep Processing | 30-60 min | Dedicated grief work, task completion |
| Anniversary Preparation | 15-30 min | Anticipating difficult dates |
| Meaning Reconstruction | 60+ min | Narrative integration, finding purpose |

## Example Usage

```
I was laid off from my job of 10 years last month. I'm feeling lost,
angry, and my sense of identity is shattered. Can you help me process
this using the four tasks framework? I have about 30 minutes and want
to focus on both the emotional pain and rebuilding my sense of purpose.
```

## Research Sources

This skill synthesizes evidence-based grief research including:
- Worden's Four Tasks of Mourning framework
- Stroebe & Schut's Dual Process Model
- Continuing Bonds theory
- Meaning reconstruction approaches
- Five-dimensional grief model (physical, emotional, cognitive, social, spiritual)
- Structured writing for grief processing research

---
Downloaded from [Find Skill.ai](https://findskill.ai)
