---
name: habit-stacking-architect
version: 1.0.0
---

# Initialization

Habit Stacking Architect is a behavioral science-based skill for designing bulletproof habit systems using the "After [CURRENT HABIT], I will [NEW HABIT]" formula. It draws from James Clear's Atomic Habits, BJ Fogg's Tiny Habits research, Charles Duhigg's Habit Loop, and implementation intention theory.

## Structure

This skill contains:
- `SKILL.md` - Main skill prompt with comprehensive habit stacking methodology

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Dependencies

None

## Post-Init Steps

### Claude Code
```bash
cp -r habit-stacking-architect/ ~/.claude/skills/habit-stacking-architect/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after the frontmatter (everything below the second `---`)
3. Paste into your AI assistant's system prompt or conversation

## Compatibility

Tested with: claude, chatgpt, gemini, copilot

## Core Capabilities

1. **Anchor Identification** - Systematically audit daily routines to find reliable triggers
2. **Stack Design** - Create precise habit-stacking formulas with appropriate sizing
3. **Implementation Planning** - Convert stacks into actionable systems with environmental cues
4. **Progressive Scaling** - Expand simple stacks into complex routine systems
5. **Failure Diagnosis** - Troubleshoot broken stacks and prescribe targeted fixes
6. **Environmental Design** - Reduce friction through physical space optimization

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{anchor_habit_description}}` | `After I pour my morning coffee` | The existing daily routine serving as trigger |
| `{{new_habit_action}}` | `I will meditate for 60 seconds` | The behavior being added to the stack |
| `{{implementation_timeline_days}}` | `21` | Days to assess automaticity |
| `{{difficulty_rating}}` | `tiny` | Behavior complexity (tiny/small/medium/ambitious) |
| `{{habit_chain_sequence}}` | `1` | Position in stack chain (1/2/3) |
| `{{reward_type}}` | `internal_celebration` | How to celebrate completion |
| `{{environmental_friction_level}}` | `low` | Setup complexity (low/medium/high) |

## Example Usage

**Morning Productivity Stack**:
"I want to build a morning productivity routine. I always make coffee around 7:15 AM before checking my email. Currently I jump straight to email and get stuck in reactive mode. I want to add: priorities planning (5 min), calendar review (3 min), and 1 min meditation. Design me a habit stack."

**Failing Habit Diagnosis**:
"I set up this habit stack 3 weeks ago: 'After dinner, I will walk for 20 minutes.' I did it for 2 weeks but only once last week. Why is this failing?"

**Life Domain Architecture**:
"Design a complete habit stacking system for my fitness goal - 30 min/day across morning stretching, midday cardio, and evening strength."

## Research Foundation

Based on peer-reviewed behavioral science:
- Implementation intention theory (94 studies, 8,000+ participants, d=0.65 effect size)
- BJ Fogg's Tiny Habits method (Stanford research)
- Charles Duhigg's Habit Loop framework
- James Clear's Atomic Habits synthesis

---
Downloaded from [Find Skill.ai](https://findskill.ai)
