---
name: healthcare-navigation-guide
version: 1.0.0
---

# Initialization

Healthcare Navigation Guide helps users navigate complex healthcare systems by providing personalized guidance on finding providers, understanding insurance, preparing for appointments, advocating for themselves, and overcoming barriers to care.

## Structure

This skill contains:
- `SKILL.md` - Main skill prompt with comprehensive healthcare navigation instructions

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Dependencies

None

## Post-Init Steps

### Claude Code
```bash
cp -r healthcare-navigation-guide/ ~/.claude/skills/healthcare-navigation-guide/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after the frontmatter
3. Paste into your AI assistant

## Compatibility

Tested with: claude, chatgpt, gemini, copilot

## Core Capabilities

| Capability | Description |
|------------|-------------|
| Provider Discovery | Find and verify in-network healthcare providers |
| Insurance Mastery | Understand plan mechanics and calculate costs |
| Appointment Optimization | Prepare comprehensively for medical visits |
| Patient Advocacy | Communicate assertively and exercise patient rights |
| Barrier Problem-Solving | Identify and overcome obstacles to care |
| Care Coordination | Manage multiple providers and prevent care gaps |
| Cost Navigation | Find financial assistance and manage healthcare costs |

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{insurance_plan_type}}` | `PPO` | Type of insurance: HMO, PPO, HDHP, Medicare, Medicaid, uninsured |
| `{{medical_condition}}` | `general healthcare` | Primary health concern or reason for navigation |
| `{{health_literacy_level}}` | `moderate` | Understanding of health concepts: basic, moderate, advanced |
| `{{navigation_intensity}}` | `standard` | Level of support: light, standard, intensive |
| `{{primary_barrier}}` | `multi-barrier` | Main obstacle: financial, transportation, language, systemic, psychological |
| `{{language_preference}}` | `English` | Primary language for healthcare communication |

## Example Prompts

**Finding a Specialist:**
"I was recently diagnosed with type 2 diabetes and need to find an endocrinologist who accepts my Blue Shield PPO insurance within 20 miles of my home. Help me verify they're in-network and prepare for my first appointment."

**Understanding Insurance Costs:**
"I have a high-deductible health plan with a $3,500 deductible. I've paid $800 so far this year. My doctor wants me to get an MRI that costs $1,200. Help me understand what I'll actually pay out of pocket."

**Advocating for Care:**
"My doctor recommended surgery but I want to try physical therapy first. They seemed dismissive when I asked about alternatives. How do I have this conversation more effectively and make sure my concerns are heard?"

## Research Foundation

This skill is based on evidence from:
- Patient navigator research and clinical best practices
- Government health resources (NIH, CMS, SHIP)
- Health literacy and patient advocacy frameworks
- Insurance education materials
- Social determinants of health interventions

## Related Skills

- Insurance & Benefits Navigator - Compare health insurance plans
- Bill Negotiation Script Writer - Negotiate medical bills
- Budget Planner - Budget for healthcare costs
- Mental Wellness Companion - Address healthcare anxiety
- Senior Wellness Companion - Healthcare navigation for 65+

---
Downloaded from [Find Skill.ai](https://findskill.ai)
