---
name: hiring-decision-validator
version: 1.0.0
---

# Initialization

The Hiring Decision Validator skill helps organizations evaluate whether they're ready to hire for a specific role by modeling complete financial and operational impact. It goes beyond typical ROI calculations to assess readiness, calculate true cost implications, validate role specifications, and identify integration risks.

## Structure

This skill contains:
- `SKILL.md` - Main skill prompt with comprehensive hiring validation framework

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Dependencies

None

## Post-Init Steps

### Claude Code
```bash
cp -r hiring-decision-validator/ ~/.claude/skills/hiring-decision-validator/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after the frontmatter (starting from "You are an expert Hiring Decision Validator...")
3. Paste into your AI assistant's system prompt or custom instructions

## Compatibility

Tested with: claude, chatgpt, gemini, copilot

## Core Capabilities

1. **Financial Impact Modeling** - Calculate true cost of hiring (50%-150% salary), recruitment ROI, and cost-per-hire breakdowns
2. **Role Specification Validation** - Assess job description clarity, competency alignment, and market competitiveness
3. **Organizational Readiness Assessment** - Evaluate team capacity, manager readiness, onboarding infrastructure
4. **Risk Identification & Mitigation** - Detect integration risks, skill gaps, retention challenges
5. **Bias Detection & Fairness Review** - Identify unconscious bias in role specs, interview questions, evaluation criteria

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{target_salary}}` | `$75,000` | Base salary for ROI and risk calculations |
| `{{recruitment_budget_percent}}` | `15%` | Percentage of salary for hiring costs |
| `{{time_to_hire_days}}` | `45` | Expected days from posting to offer acceptance |
| `{{bad_hire_impact_multiplier}}` | `1.0x` | Multiplier for bad hire cost (0.5-1.5x salary) |
| `{{organizational_readiness_score}}` | `7` | Team capacity to integrate (scale 1-10) |
| `{{roi_calculation_method}}` | `productivity` | Value model: revenue, productivity, cost_savings, mixed |

## Key Formulas

**Recruitment ROI**
```
ROI (%) = [(Net Benefits - Total Costs) / Total Costs] × 100
```

**Cost Per Hire**
```
CPH = (Total Internal Costs + Total External Costs) / Number of Hires
```

**Bad Hire Cost**
```
Bad Hire Cost = Salary × Impact Multiplier (0.5 to 1.5)
```

## Industry Benchmarks

| Metric | Standard |
|--------|----------|
| Cost Per Hire | $1,000-$4,700 |
| Time to Hire | 40-50 days |
| Recruitment ROI | 50-100% typical |
| Bad Hire Cost | 50-150% of salary |

## Example Usage

```
I'm considering hiring a Senior Engineering Manager at $165,000 salary.
Our recruitment budget is 18% of salary, and we typically take 52 days to hire.
Before we post this role, I need to model the true cost, understand bad hire
risk exposure, and get a readiness assessment.
```

## Research Sources

- AIHR: How To Quantify Recruitment ROI
- Cirqle Group: The Cost of a Bad Hire in Tech
- IEEE: AI Hiring with LLMs Multi-Agent Framework
- Joveo: AI Maturity Model for Talent Acquisition 2025
- SIOP: AI Assessment Validation Standards

---
Downloaded from [Find Skill.ai](https://findskill.ai)
