---
name: home-inspection-red-flag-decoder
version: 1.0.0
---

# Initialization

Home Inspection Red Flag Decoder - Translate home inspection reports into plain English, assess defect severity, estimate repair costs, and develop negotiation strategies for homebuyers.

## Structure

This skill contains:
- `SKILL.md` - Main skill prompt with instructions for analyzing home inspection reports

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Dependencies

None

## Post-Init Steps

### Claude Code
```bash
cp -r home-inspection-red-flag-decoder/ ~/.claude/skills/home-inspection-red-flag-decoder/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after the frontmatter
3. Paste into your AI assistant

## Compatibility

Tested with: claude, chatgpt, gemini, copilot

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{repair_threshold_amount}}` | `$1000` | Minimum dollar amount per item to warrant negotiation |
| `{{home_purchase_price}}` | `$350000` | Total purchase price of the property being evaluated |
| `{{market_conditions}}` | `balanced` | Current real estate market conditions (tight, balanced, buyer's) |
| `{{inspection_contingency_days}}` | `10` | Days remaining in inspection contingency period |
| `{{buyer_capital_available}}` | `$20000` | Post-closing cash reserves for repairs |
| `{{specialist_evaluation_budget}}` | `$1500` | Budget for specialist assessments |

## Core Capabilities

1. **Technical Jargon Translation** - Convert inspection terminology into plain-language explanations
2. **Severity Assessment** - Classify findings as safety hazards, major defects, minor issues, or maintenance items
3. **Cost Estimation Framework** - Provide repair cost ranges by category
4. **Negotiation Leverage Analysis** - Determine which findings justify price reductions or repair credits
5. **Prioritization Guidance** - Distinguish between urgent repairs and items that can be deferred
6. **Contingency Clause Guidance** - Explain inspection contingency rights
7. **Specialist Evaluation Guidance** - Recommend when professional assessments are needed

## Example Usage

```
User: "I got my home inspection report back and it says 'The HVAC system is a
Bryant 10-year-old unit showing signs of refrigerant loss and audible compressor
noise during operation. Recommend replacement within 2 years.' What does this
mean in plain English and is it a deal-breaker? I'm buying a $350,000 home."

AI: [Provides translation, severity assessment, cost estimate, and negotiation guidance]
```

## Research Sources

- NACHI Standards of Practice (https://www.nachi.org/sop.htm)
- ASHI Standard of Practice for Home Inspections
- InterNACHI Glossary of Home Inspection Terms
- Real estate negotiation best practices guides

---
Downloaded from [Find Skill.ai](https://findskill.ai)
