---
name: home-repair-diy-troubleshooter
version: 1.0.0
description: Get step-by-step repair guidance for home fixes with diagnosis, tool lists, cost estimates, and professional recommendations
author: FindSkill.ai
license: MIT
---

# Initialization

An expert home repair advisor that helps homeowners diagnose problems, understand repair difficulty, get step-by-step DIY guidance, and know when to call professionals. Covers plumbing, electrical, HVAC, appliances, and structural issues with a safety-first approach.

## Overview

This is a prompt-only skill. Simply copy the content from SKILL.md and paste it into your AI assistant.

**Time to initialize**: ~1 minute

## Directory Structure

```
home-repair-diy-troubleshooter/
├── SKILL.md    # Main skill instructions (copy this)
└── INIT.md     # This initialization file
```

## Dependencies

None - this is a prompt-only skill.

## Files to Generate

None - all content is in SKILL.md.

## Post-Init Steps

### Claude Code
```bash
# Copy to your skills directory
cp -r home-repair-diy-troubleshooter/ ~/.claude/skills/home-repair-diy-troubleshooter/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy the content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt or chat

## Compatibility

Tested with: Claude, ChatGPT, Gemini, Copilot

## Variables

Customize these placeholders in the skill:

| Variable | Default | Description |
|----------|---------|-------------|
| `{{skill_level}}` | `beginner` | User's DIY experience level |
| `{{tool_availability}}` | `basic` | Basic or advanced tool collection |
| `{{home_type}}` | `house` | Type of home (house, apartment, condo) |
| `{{risk_tolerance}}` | `moderate` | Comfort with DIY vs calling pros |

## Key Features

### Problem Diagnosis
- Symptom-based troubleshooting
- System identification (plumbing, electrical, HVAC, etc.)
- Multiple likely causes ranked by probability

### DIY vs Professional Guidance
- Clear difficulty ratings (Easy to Call Pro)
- Safety-first assessment
- Red flag situations that always need professionals

### Step-by-Step Instructions
- Detailed repair guides with timing
- Tool and parts lists with costs
- Technique tips and common mistakes
- Testing and verification steps

### Cost Estimation
- DIY cost (parts/materials only)
- Professional cost (service call + labor + parts)
- When to get multiple quotes

## Coverage Areas

### Plumbing
- Dripping faucets, clogged drains
- Running toilets, low water pressure
- Leaks, water heater issues

### Electrical
- Dead outlets, flickering lights
- Tripping breakers, GFCI issues
- Safety-first approach with clear limits

### HVAC
- Filter replacement, thermostat issues
- AC/heating troubleshooting
- When refrigerant or gas work requires pros

### Appliances
- Washer, dryer, dishwasher
- Refrigerator, garbage disposal
- Error code interpretation

### Structural
- Doors, windows, weatherstripping
- Drywall repair, caulking
- When foundation issues need pros

## Example Usage

```
My bathroom faucet is dripping constantly. It's a single-handle faucet and the drip is coming from the spout even when it's fully turned off. I'm a complete beginner with home repairs but I have basic tools like screwdrivers and pliers. Can you help me fix this, or should I call a plumber? How much would either option cost?
```

## Safety Emphasis

This skill prioritizes safety by:
- Always recommending utility shutoffs before work
- Identifying red flag situations (gas, main electrical, structural)
- Requiring protective equipment when appropriate
- Encouraging permits and code compliance

---
Downloaded from [Find Skill.ai](https://findskill.ai)
