---
name: house-hunting-priority-ranker
version: 1.0.0
---

# House Hunting Priority Ranker - Initialization

A systematic decision-support assistant that helps prospective homebuyers evaluate properties objectively using weighted criteria, must-have filtering, and trade-off analysis. Based on multi-criteria decision analysis (MCDA) and Analytic Hierarchy Process (AHP) research.

## Structure

This skill contains:
- `SKILL.md` - Main skill prompt with comprehensive instructions for property evaluation

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Dependencies

None required. This skill works with any AI assistant that can process natural language prompts.

## Post-Init Steps

### Claude Code
```bash
cp -r house-hunting-priority-ranker/ ~/.claude/skills/house-hunting-priority-ranker/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy all content after the frontmatter (starting from "You are an expert House Hunting Priority Ranker...")
3. Paste into your AI assistant as a system prompt or conversation starter

## Compatibility

Tested with:
- Claude (claude.ai, Claude Code)
- ChatGPT (GPT-4, GPT-4o)
- Gemini (Gemini Pro, Gemini Advanced)
- Copilot (Microsoft Copilot)

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{max_budget}}` | `400000` | Upper price limit that automatically disqualifies properties |
| `{{min_bedrooms}}` | `3` | Minimum bedroom count (must-have filter) |
| `{{max_commute_minutes}}` | `45` | Maximum acceptable commute time |
| `{{priority_weights}}` | `{"location": 30, "price": 25, "size": 20, "condition": 15, "amenities": 10}` | Weight distribution for criteria |
| `{{fixable_cost_threshold}}` | `50000` | Maximum repair costs before triggering red flag |
| `{{must_haves}}` | `["3+ bedrooms", "safe neighborhood", "within budget", "acceptable commute"]` | Deal-breaker criteria |

## Quick Start

After installing, start with:

> "I'm a first-time homebuyer with a budget of $450K. My must-haves are 3+ bedrooms, safe neighborhood, and commute under 30 minutes to downtown. Help me set up my evaluation framework."

The skill will guide you through:
1. Defining your criteria and weights
2. Evaluating individual properties
3. Comparing and ranking multiple options
4. Analyzing trade-offs between finalists

## Core Capabilities

- **Criteria Definition**: Create personalized weighted scoring frameworks
- **Property Evaluation**: Score properties against your criteria (0-100 scale)
- **Comparative Ranking**: Rank multiple properties objectively
- **Trade-Off Analysis**: Navigate compromises with fixable vs. non-fixable framework
- **Scenario Planning**: Explore "what-if" scenarios (budget changes, criteria adjustments)

## Research Foundation

This skill is based on:
- Analytic Hierarchy Process (AHP) for housing decisions
- Multi-Criteria Decision Analysis (MCDA) frameworks
- Behavioral economics research on loss aversion in major purchases
- Real estate industry best practices for property evaluation

---
Downloaded from [Find Skill.ai](https://findskill.ai)
