---
name: industry-trend-analyzer
version: 1.0.0
---

# Industry Trend Analyzer - Initialization

Identify market trends, map technology adoption curves, assess competitive landscape shifts, and generate strategic recommendations using PESTEL, Porter's Five Forces, and hype cycle frameworks.

## What This Skill Does

This skill transforms you into a senior strategic intelligence analyst who helps users:
- Conduct full PESTEL analysis across political, economic, social, technological, environmental, and legal dimensions
- Apply Porter's Five Forces to assess industry structural attractiveness and competitive intensity
- Map technologies on the Gartner Hype Cycle and Rogers' Adoption Curve to guide investment timing
- Size market opportunities using TAM-SAM-SOM methodology with top-down and bottom-up approaches
- Detect weak signals of disruption that most analysts miss using systematic environmental scanning
- Build scenario plans with 2x2 uncertainty matrices, no-regret moves, and early warning indicators
- Track regulatory trajectories and identify where regulation creates competitive moats
- Generate executive-ready strategic briefs with prioritized recommendations and monitoring dashboards

## Package Structure

```
industry-trend-analyzer/
├── SKILL.md      # Main skill prompt (copy to your AI assistant)
├── INIT.md       # This initialization file
└── industry-trend-analyzer.zip  # Complete package
```

## Files to Generate

None (prompt-only skill)

## Installation

### Claude Code / Claude Desktop

```bash
# Copy skill to Claude skills directory
cp -r industry-trend-analyzer/ ~/.claude/skills/industry-trend-analyzer/
```

Then reference in your project's `CLAUDE.md`:
```markdown
## Available Skills
- `industry-trend-analyzer` - Analyze industry trends using PESTEL, Porter's Five Forces, hype cycles, and market sizing
```

### ChatGPT / GPT-4

1. Open `SKILL.md`
2. Copy all content after the YAML frontmatter (after the second `---`)
3. Paste into ChatGPT as your initial prompt
4. Begin your industry analysis request

### Gemini / Other AI Assistants

1. Open `SKILL.md`
2. Copy the full skill content
3. Paste into your AI assistant
4. Start with your industry and analysis scope

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{my_industry}}` | `SaaS / Cloud Computing` | The industry or sector to analyze |
| `{{my_analysis_timeframe}}` | `3-5 years` | Forward-looking time horizon |
| `{{my_company_size}}` | `mid-market` | Organization scale (startup to Fortune 500) |
| `{{my_geographic_focus}}` | `North America` | Primary market region |
| `{{my_analysis_depth}}` | `comprehensive` | Quick-scan, standard, or comprehensive |
| `{{my_strategic_priority}}` | `growth` | Growth, defense, diversification, or efficiency |
| `{{my_risk_appetite}}` | `moderate` | Conservative, moderate, or aggressive |

## Quick Start

After installing, try this prompt:

```
I'm the CEO of a Series B fintech startup (digital lending platform) with $15M ARR.
I need to understand how the lending industry will evolve over the next 3-5 years.

Specifically:
1. Run a PESTEL analysis on US digital lending
2. Map where AI credit scoring, embedded lending, and open banking sit on the hype cycle
3. Identify the top 5 trends reshaping our competitive landscape
4. Size the embedded lending market opportunity
5. Build a 2x2 scenario matrix around interest rate trajectory and regulatory tightening
6. Give me a strategic brief I can share with my board and investors
```

## Key Frameworks Included

### PESTEL Analysis
- Political, Economic, Social, Technological, Environmental, Legal scanning
- Impact x Probability scoring for prioritization
- Critical uncertainty identification

### Porter's Five Forces
- Structural attractiveness assessment
- Competitive intensity measurement with trend direction
- Strategic group mapping and mobility barriers

### Gartner Hype Cycle
- Five-phase technology maturity mapping
- Investment timing recommendations per phase
- Technology convergence analysis for amplified disruption

### Rogers' Technology Adoption Curve
- Adoption stage identification (Innovators through Laggards)
- Chasm crossing assessment
- Whole product requirements for mainstream adoption

### TAM-SAM-SOM Market Sizing
- Top-down and bottom-up methodologies
- Growth driver and headwind identification
- Opportunity scoring with weighted dimensions

### Scenario Planning
- Two-axis uncertainty matrix
- Four-scenario narrative development
- No-regret moves, big bets, and real options identification
- Early warning indicator system

### Weak Signal Detection
- Fringe innovation scanning
- Regulatory whisper tracking
- Talent migration and funding pattern analysis
- Convergence scoring for disruption potential

### Regulatory Landscape Mapping
- Multi-dimensional regulatory tracking
- Trajectory prediction methodology
- Regulatory moat opportunity identification

### Strategic Brief Generation
- Executive summary with top trends and responses
- Prioritized recommendations by time horizon
- Risk assessment with mitigations
- Monitoring dashboard with KPIs

## Output Formats

The skill generates structured deliverables including:
- PESTEL analysis scorecards
- Five Forces assessment tables
- Hype cycle technology maps
- Market sizing breakdowns
- Scenario planning matrices
- Disruptor radar profiles
- Competitive landscape maps
- Executive strategic briefs with monitoring dashboards

## Industry-Specific Modules

The skill includes specialized analysis modules for:
- **Technology / SaaS** — PLG dynamics, NRR, platform ecosystems, open-source competition
- **Healthcare** — Regulatory approvals, payer dynamics, precision medicine, telehealth maturation
- **Financial Services** — Embedded finance, open banking, digital assets, real-time payments
- **Manufacturing** — Industry 4.0, reshoring, additive manufacturing, digital twins
- **Energy** — Renewables cost curves, battery storage, carbon capture, hydrogen economy
- **Retail & Consumer** — Omnichannel evolution, social commerce, personalization, last-mile innovation

## Best Use Cases

- Strategic planning cycles (annual/quarterly)
- Board presentations and investor updates
- New market entry evaluation
- Technology investment decisions
- M&A due diligence (industry assessment)
- Competitive response planning
- Regulatory change impact assessment
- Innovation portfolio prioritization

---
Downloaded from [Find Skill.ai](https://findskill.ai)
