---
name: instructions-writer
version: 1.0.0
description: Turn any process into clear, step-by-step instructions anyone can follow
author: FindSkill.ai
license: MIT
---

# Instructions Writer — Initialization

## Overview

This is a prompt-only skill for writing clear, methodical instructions for any process. It uses a proven structure with 5 formatting rules, multiple output formats, and audience-specific adaptations.

**Time to initialize**: Instant — no setup needed.

## Package Contents

- `SKILL.md` — Complete skill with structure templates and format options
- `INIT.md` — This initialization guide

## Directory Structure

```
instructions-writer/
├── SKILL.md    # Main skill with templates and quality checklist
└── INIT.md     # This file
```

## Dependencies

None — this is a prompt-only skill.

## Quick Start

### Claude / Claude Code
1. Open `SKILL.md`, copy content after frontmatter
2. Paste into a new conversation
3. Tell Claude what process you need instructions for

### ChatGPT / Gemini / Copilot
Same process — paste and describe the task and audience.

## Core Capabilities

1. **Proven Structure** — Title, overview, prerequisites, steps, troubleshooting, done state
2. **5 Formatting Rules** — One action per step, verb-first, expected results, confusion flags, consistent formatting
3. **5 Output Formats** — Numbered steps, checklist, SOP, quick reference card, tutorial style
4. **5 Audience Levels** — Complete beginners, coworkers, technical users, children, customers
5. **Quality Checklist** — 11-point verification before delivery
6. **Common Instruction Types** — Software, workplace, physical, cooking, assembly, training

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `process` | `` | The process or task to write instructions for |
| `audience` | `general audience` | Who will follow these instructions |
| `format` | `numbered steps` | Output format (numbered steps, checklist, SOP, quick reference card) |

## Usage Examples

### Example 1: Software Process

**User:** "Write instructions for submitting an expense report in Concur for my team."

**AI Response:** Creates a complete how-to guide with title, overview, prerequisites checklist, numbered steps with one action each, expected results after each step, troubleshooting section, and done state.

### Example 2: Physical Task

**User:** "I need assembly instructions for a standing desk. The audience is regular consumers."

**AI Response:** Creates beginner-friendly instructions with parts list, tools needed, safety warnings, numbered steps with expected results, and a troubleshooting section for common issues.

### Example 3: SOP Format

**User:** "Create an SOP for our customer support team's refund process."

**AI Response:** Creates a formal SOP with department, approval, purpose, scope, and formal numbered steps with policy context and approval workflows.

## Troubleshooting

| Issue | Solution |
|-------|----------|
| Instructions too detailed | Specify audience as "coworkers" or "technical users" |
| Instructions too brief | Specify audience as "complete beginners" |
| Wrong format | Ask for specific format: checklist, SOP, quick reference card |
| Missing context | Provide the end goal, tools needed, and who's reading |
| Too many steps | Ask for a "quick reference card" version |

## Best Practices

1. **Always state the end result** — readers need to know what "done" looks like
2. **One action per step** — the single most important rule
3. **Test with a beginner** — if they can follow it, anyone can
4. **Include screenshots** — add placeholders where visual guidance would help
5. **Update regularly** — processes change, instructions should too
6. **Add time estimates** — readers appreciate knowing how long each section takes

---
Downloaded from [Find Skill.ai](https://findskill.ai)
