---
title: "Instructions Writer"
description: "Turn any process into clear, step-by-step instructions anyone can follow. Perfect for SOPs, how-to guides, training docs, recipes, and assembly directions."
platforms:
  - Claude
  - ChatGPT
  - Gemini
  - Copilot
difficulty: beginner
variables:
  - name: "process"
    default: ""
    description: "The process or task to write instructions for"
  - name: "audience"
    default: "general audience"
    description: "Who will follow these instructions"
  - name: "format"
    default: "numbered steps"
    description: "Output format (numbered steps, checklist, SOP, quick reference card)"
---

# Instructions Writer

A skill that transforms any process into clear, step-by-step instructions that anyone can follow. Write instructions for software workflows, workplace processes, physical tasks, cooking recipes, assembly guides, training materials, and more.

## When to Use This Skill

- Writing SOPs (Standard Operating Procedures) for your team
- Creating how-to guides for customers or users
- Documenting training materials for new hires
- Writing recipes or assembly instructions
- Creating quick reference cards for repeated tasks
- Building help center articles or knowledge base content

## Core Philosophy

Write for the person who has never done this before. If an experienced person reads your instructions, they'll simply skip steps they already know — but if a beginner reads unclear instructions, they're stuck.

**Rule: One action per step, no assumed knowledge, always state the expected result.**

## Proven Structure

### Title
Clear, action-oriented: "How to [Accomplish Specific Goal]"
- Good: "How to Submit an Expense Report in Concur"
- Bad: "Expense Report Instructions"

### Overview (2-3 sentences)
What the reader will accomplish, how long it takes, and what they'll need.

### Before You Start (Prerequisites)
List everything needed before step 1 as a checklist.

### Step-by-Step Instructions
Follow these rules for each step:

1. **One action per step** — Never combine two actions
2. **Start each step with a verb** — Click, Type, Select, Open, Navigate
3. **Include what the user should see** — Confirmation of success
4. **Flag potential confusion** — Use notes, tips, and warnings
5. **Use consistent formatting** — Bold UI elements, quote exact text

### Troubleshooting
Anticipate 2-3 common problems with solutions.

### Done / Expected Result
Clearly state what "finished" looks like.

## Format Options

| Format | Best For |
|--------|----------|
| Numbered Steps | Processes that must follow a specific order |
| Checklist | Tasks that can be done in any order |
| SOP | Formal workplace documentation |
| Quick Reference Card | Tasks people do repeatedly |
| Tutorial Style | Learning-focused content |

## Audience Adaptation

- **Complete Beginners:** Define every term, describe every button
- **Coworkers:** Skip basic setup, use company terms
- **Technical Users:** Use precise terminology, include CLI examples
- **Children:** Simple words, fun comparisons, encouragement
- **Customers:** Professional, no jargon, include support contact

## Quality Checklist

- [ ] Title is specific and action-oriented
- [ ] Overview states what, how long, and what's needed
- [ ] Prerequisites listed before step 1
- [ ] Each step starts with a verb
- [ ] Each step contains only ONE action
- [ ] Expected results stated ("You should see...")
- [ ] Warnings and tips flag common pitfalls
- [ ] UI elements are bold or quoted consistently
- [ ] Troubleshooting covers 2-3 common problems
- [ ] "Done" state is clearly described

---
Downloaded from [Find Skill.ai](https://findskill.ai)
