---
name: insurance-benefits-navigator
version: 1.0.0
description: Understand health insurance plans, compare coverage, and maximize benefits
author: FindSkill.ai
license: MIT
---

# Initialization

Help individuals and families understand health insurance options, compare plans, decode medical bills, and make informed decisions during open enrollment.

## Overview

This is a prompt-only skill with no scripts to generate. The skill provides:
- Health insurance plan comparison frameworks
- HSA vs FSA vs HRA explanations
- Cost scenario analysis methods
- Open enrollment checklists
- Subsidy eligibility guidance

**Time to initialize**: Immediate (no setup required)

## Directory Structure

```
insurance-benefits-navigator/
├── SKILL.md    # Main skill instructions
└── INIT.md     # This file
```

## Dependencies

None required.

## Files to Generate

None (prompt-only skill).

## Post-Init Steps

### Claude Code
```bash
# Copy to your skills directory
cp -r insurance-benefits-navigator/ ~/.claude/skills/insurance-benefits-navigator/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy the content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt or chat

## Compatibility

Tested with: claude, chatgpt, gemini, copilot

## Variables

Customize these in your requests:

| Variable | Default | Description |
|----------|---------|-------------|
| `coverage_type` | `health` | Type of insurance (health, dental, vision) |
| `employment_status` | `employer` | Source (employer, marketplace, medicare) |
| `household_size` | `` | Number needing coverage |
| `annual_income` | `` | For subsidy calculations |
| `health_needs` | `moderate` | Expected usage level |

## Example Usage

```
I'm comparing health insurance plans during open enrollment. Family of 4,
household income $85,000. We have moderate healthcare needs - annual
checkups, occasional urgent care visits, and one family member takes a
regular prescription medication. Help me understand the difference between
the Bronze, Silver, and Gold plans offered and which would be best for us.
```

## Key Features

### Coverage Types Explained
- Employer plans (PPO, HMO, EPO, POS, HDHP)
- ACA Marketplace (Bronze/Silver/Gold/Platinum)
- Medicare (Parts A, B, C, D, Medigap)
- Medicaid and CHIP
- COBRA continuation

### Savings Accounts Compared
- HSA: Triple tax advantage, portable, invests
- FSA: Pre-tax, use-it-or-lose-it (mostly)
- HRA: Employer-funded reimbursement

### Analysis Provided
- Term explanations (deductible, copay, coinsurance)
- Plan tier comparisons
- Cost scenario calculations
- Subsidy eligibility checks
- Network verification guidance

### Seasonal Relevance
- ACA Open Enrollment: November 1 - January 15
- Medicare: October 15 - December 7
- Employer plans: Typically October-November

---
Downloaded from [Find Skill.ai](https://findskill.ai)
