---
name: interview-prep-simulator
version: 1.0.0
---

# Initialization

Interview Prep Simulator provides realistic mock interview practice with AI-powered feedback. It helps candidates master the STAR method, conduct full mock interviews, and track improvement across multiple sessions for behavioral, technical, and situational interviews.

## Structure

This skill contains:
- `SKILL.md` - Main skill prompt with comprehensive interview coaching instructions

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Dependencies

None

## Post-Init Steps

### Claude Code
```bash
cp -r interview-prep-simulator/ ~/.claude/skills/interview-prep-simulator/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after the frontmatter (starting from "You are an expert Interview Prep Simulator...")
3. Paste into your AI assistant's custom instructions or conversation

## Compatibility

Tested with: claude, chatgpt, gemini, copilot

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{interview_type}}` | `behavioral` | Type of interview (behavioral, technical, system_design, case_study, hybrid) |
| `{{role_title}}` | `software_engineer` | Target job role for customized questions |
| `{{seniority_level}}` | `intermediate` | Experience level (entry_level, intermediate, senior, lead, executive) |
| `{{interview_duration_minutes}}` | `30` | Length of mock interview in minutes |
| `{{company_name}}` | `generic` | Target company for customization |
| `{{focus_competencies}}` | `communication, problem_solving, teamwork` | Specific competencies to emphasize |

## Quick Start

After installing, start a conversation with your AI assistant and say:

> "I want to practice for a [role] interview at [company]. Can you run a [duration]-minute mock interview focused on [competencies]?"

Examples:
- "I want to practice for a Senior Product Manager interview at Google. Can you run a 45-minute mock interview focused on strategic thinking and stakeholder management?"
- "Help me prepare for a Software Engineer interview. I want to practice behavioral questions using the STAR method."
- "Run a diagnostic assessment to identify my interview weaknesses."

## Features Overview

1. **Adaptive Mock Interviews** - Realistic simulations with follow-up questions based on your responses
2. **STAR Method Training** - Learn and master the Situation-Task-Action-Result framework
3. **Multi-Interview Types** - Behavioral, technical, system design, case study, and hybrid formats
4. **Role-Specific Customization** - Tailored for software engineers, product managers, data scientists, sales, and executives
5. **Comprehensive Feedback** - Detailed reports with competency scores, STAR analysis, and improvement recommendations
6. **Company-Specific Prep** - Customized questions for Google, Amazon, Meta, Microsoft, and more
7. **Performance Tracking** - Track improvement across multiple practice sessions

---
Downloaded from [Find Skill.ai](https://findskill.ai)
