---
name: investment-beginner-onboarder
version: 1.0.0
---

# Initialization

Investment Beginner Onboarder is a comprehensive skill for teaching complete beginners how to invest. It covers stocks, ETFs, index funds, 401(k)s, Roth IRAs, portfolio construction, dollar-cost averaging, and common beginner mistakes to avoid.

## Structure

This skill contains:
- `SKILL.md` - Main skill prompt with complete investment education framework

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Dependencies

None

## Post-Init Steps

### Claude Code
```bash
cp -r investment-beginner-onboarder/ ~/.claude/skills/investment-beginner-onboarder/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after the frontmatter (starting from "You are an expert investment educator...")
3. Paste into your AI assistant's system prompt or custom instructions

## Compatibility

Tested with: claude, chatgpt, gemini, copilot

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{initial_capital}}` | `1000` | Starting investment amount in dollars |
| `{{monthly_contribution}}` | `500` | Regular recurring investment amount |
| `{{stock_allocation_pct}}` | `60` | Percentage allocated to stocks vs bonds |
| `{{investment_horizon_years}}` | `30` | Years until funds are needed |
| `{{rebalancing_frequency}}` | `annual` | How often to adjust portfolio allocations |
| `{{expense_ratio_threshold}}` | `0.20` | Maximum acceptable annual fund fee percentage |

## Quick Start

After installation, the skill will interactively guide users through:

1. **Assessment** - Understanding their financial situation, goals, and risk tolerance
2. **Account Selection** - Choosing between 401(k), Roth IRA, Traditional IRA, or taxable brokerage
3. **Platform Selection** - Recommending Fidelity, Vanguard, Schwab, or SoFi based on needs
4. **Portfolio Construction** - Building a diversified portfolio using the three-fund approach
5. **Implementation** - Step-by-step guidance to open accounts and place first trades
6. **Ongoing Management** - Setting up automatic contributions and annual rebalancing

## Key Capabilities

- Teaching investment fundamentals (stocks, bonds, ETFs, index funds)
- Retirement account education (401k, Traditional IRA, Roth IRA)
- Portfolio construction using three-fund or target-date approach
- Dollar-cost averaging implementation
- Platform comparison and recommendations
- Common mistake prevention

## Example Prompts

**Complete Beginner:**
> "I'm 28 years old with $5,000 to invest and can contribute $500/month. I've never invested before and want to keep things simple. I work for a company offering a 401(k) with 3% employer match. Walk me through how to get started."

**Portfolio Question:**
> "I want to build a 60/40 diversified portfolio with $20,000 to start. What specific ETFs should I buy and in what proportions?"

**Retirement Account:**
> "Should I contribute to Traditional or Roth 401(k)? I'm 35, make $95,000/year, and expect higher income in the future."

---
Downloaded from [Find Skill.ai](https://findskill.ai)
