---
name: language-learning-motivator
version: 1.0.0
---

# Initialization

Language Learning Motivator is an AI coaching skill that helps users design sustainable language learning plans combining realistic SMART goals, habit loop automation (using the Atomic Habits framework), and intrinsic motivation cultivation. It addresses the psychology behind successful language acquisition—helping learners overcome demotivation, build lasting study habits, and maintain momentum from initial enthusiasm through long-term fluency development.

## Structure

This skill contains:
- `SKILL.md` - Main skill prompt with comprehensive instructions for motivation coaching

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Dependencies

None

## Post-Init Steps

### Claude Code
```bash
cp -r language-learning-motivator/ ~/.claude/skills/language-learning-motivator/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after the frontmatter (starting from "You are an expert Language Learning Motivation Coach...")
3. Paste into your AI assistant's system prompt or custom instructions

## Compatibility

Tested with: claude, chatgpt, gemini, copilot

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{target_proficiency_level}}` | `B1` | CEFR target level (A1, A2, B1, B2, C1, C2) |
| `{{weekly_study_minutes}}` | `300` | Total minutes per week devoted to language learning |
| `{{habit_anchor_time}}` | `morning` | Existing daily routine to link language learning to |
| `{{intrinsic_driver}}` | `personal_curiosity` | Primary internal motivation (cultural_interest, career_goal, relationship, travel, heritage, personal_challenge) |
| `{{accountability_type}}` | `habit_tracker` | Accountability system (habit_tracker, accountability_partner, group, coach, app_streak) |
| `{{demotivation_risk_level}}` | `medium` | Vulnerability to demotivation (low, medium, high) |

## Core Capabilities

1. **Goal-Setting with SMART Framework** - Create specific, measurable, achievable, relevant, and time-bound language goals aligned with CEFR proficiency levels
2. **Habit Loop Design** - Build sustainable micro-habits using cue-craving-response-reward cycles and habit stacking
3. **Intrinsic Motivation Cultivation** - Identify personal drivers and design learning experiences that foster internal drive
4. **Demotivation Diagnosis & Recovery** - Recognize early signs of demotivation and implement targeted intervention strategies
5. **Progress Tracking & Accountability** - Establish feedback loops, habit trackers, and accountability partnerships
6. **Learning Resource Alignment** - Match learners with tools suited to their proficiency level and learning style
7. **Mindset Resilience** - Transform fixed mindsets into growth-oriented perspectives

## Key Concepts Covered

- CEFR Proficiency Levels (A1-C2)
- Intrinsic vs. Extrinsic Motivation
- Ideal L2 Self (L2 Motivational Self System)
- Habit Loop (Atomic Habits Framework)
- Spaced Repetition & Leitner System
- Affective Filter
- Fixed vs. Growth Mindset
- Habit Stacking
- Micro-Habits
- Accountability Partnerships

## Research Sources

Based on peer-reviewed research from:
- PMC/NIH language learning motivation studies
- Frontiers in Psychology (motivation-emotion dynamics)
- Atomic Habits framework (James Clear)
- CEFR (Common European Framework of Reference)
- L2 Motivational Self System (Dörnyei)
- Self-Determination Theory

---
Downloaded from [Find Skill.ai](https://findskill.ai)
