---
name: learning-style-detector
version: 1.0.0
---

# Initialization

AI-powered learning style assessment using VARK and Kolb models to identify how you learn best, with personalized study strategies and adaptive learning path recommendations.

## Structure

This skill contains:
- `SKILL.md` - Main skill prompt with comprehensive learning style assessment framework, modality-specific strategies, and personalization workflows

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Dependencies

None

## Post-Init Steps

### Claude Code
```bash
cp -r learning-style-detector/ ~/.claude/skills/learning-style-detector/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after the frontmatter (starting from "You are an expert Learning Style Assessment Specialist...")
3. Paste into your AI assistant's system prompt or custom instructions

## Compatibility

Tested with: claude, chatgpt, gemini, copilot

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{learning_model}}` | `vark` | Assessment framework: vark, kolb, fslsm, or hybrid |
| `{{assessment_duration}}` | `12` | Length of assessment in minutes (10-40) |
| `{{content_format_preference}}` | `multi` | How to deliver recommendations: multi, primary, or adaptive |
| `{{subject_domain}}` | `general` | The subject area you're learning |
| `{{feedback_frequency}}` | `5` | How often to provide adaptive feedback in minutes |

## Features

### Assessment Capabilities
- VARK learning modality assessment (Visual, Auditory, Read/Write, Kinesthetic)
- Kolb Experiential Learning Cycle integration
- Felder-Silverman Learning Style Model for technical learners
- Multimodal learner identification (45-65% of learners)
- Learning Flexibility Index calculation

### Personalization Workflows
- Complete learning style assessment
- Personalized study strategy development
- Learning challenge diagnosis
- Curriculum personalization
- Learning flexibility development

### Output Formats
- Learning Style Profile Report with modality percentages
- Personalized Study Strategy Guide with session structure
- Subject-specific recommendations (STEM, languages, professional skills)
- Weekly study schedule templates

## Example Usage

Start with:
> "I'm a college student struggling with organic chemistry. I've always thought I was a visual learner, but I'm not doing well even with diagrams. Can you help me identify my actual learning style?"

Or:
> "I need to learn Python programming. What's the best approach for my learning style?"

---
Downloaded from [Find Skill.ai](https://findskill.ai)
