---
name: legal-document-analyzer
version: 1.0.0
description: Plain-English legal document analyzer for consumer contracts
author: FindSkill.ai
license: MIT
---

# Initialization

This skill provides plain-English analysis of legal documents for everyday people, helping them understand contracts before signing.

## Overview

This is a **prompt-only skill** with no scripts to generate. The skill content in SKILL.md provides complete instructions for analyzing contracts, leases, and legal documents.

**Time to initialize**: ~1 minute (copy only)

## Directory Structure

```
legal-document-analyzer/
├── SKILL.md         # Main skill instructions
└── INIT.md          # This file
```

## Dependencies

None required. This is a prompt-only skill.

## Files to Generate

None. Simply use SKILL.md directly.

## Post-Init Steps

### For Claude Code Users

```bash
# Copy to your skills directory
cp -r legal-document-analyzer/ ~/.claude/skills/legal-document-analyzer/
```

### For Other AI Assistants

1. Open `SKILL.md`
2. Copy the content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt or chat

## Usage Examples

### Analyzing a Rental Lease

```
I'm about to sign an apartment lease. Here's the contract:

[Paste lease text]

I'm the tenant. I'm worried about:
- What happens if I break the lease early
- Hidden fees
- Security deposit return conditions

Can you explain what I'm agreeing to in plain English?
```

### Reviewing a Freelance Contract

```
A new client sent me this contract:

[Paste contract text]

I'm the freelancer. I want to understand:
- Payment terms and what could delay payment
- Who owns the work I create
- What happens if the project is cancelled

Please analyze and flag any red flags.
```

### Understanding Terms of Service

```
I'm signing up for this SaaS product. Here are their terms:

[Paste terms of service]

I'm the customer. What am I agreeing to? Any concerns about data usage or auto-renewal?
```

## Compatibility

Tested with: Claude, ChatGPT, Gemini, Copilot

## Variables

Customize these placeholders when using the skill:

| Variable | Default | Description |
|----------|---------|-------------|
| `{{document_type}}` | rental lease | Type of document being analyzed |
| `{{your_role}}` | tenant/customer | Your position in the agreement |
| `{{concerns}}` | hidden fees, early termination | Specific areas you're worried about |

## What This Skill Does

1. **Translates legalese** - Explains complex clauses in everyday language
2. **Flags red flags** - Identifies clauses that could cost money or limit rights
3. **Itemizes costs** - Lists all upfront, recurring, and potential penalty costs
4. **Provides negotiation scripts** - Gives specific language to push back
5. **Explains your rights** - Reminds you of protections that may apply

## Limitations

- This is educational analysis, not legal advice
- Cannot account for all state/local laws
- Complex or high-stakes contracts should be reviewed by an attorney
- Cannot analyze documents with images or special formatting

---
Downloaded from [FindSkill.ai](https://findskill.ai)
