---
title: "Legal Document Plain-English Analyzer"
description: "Scan contracts and fine print, identify risky clauses like hidden fees and auto-renewals, summarize key terms in plain English, and get negotiation points. This skill requires initialization before first use - run INIT.md instructions."
platforms:
  - claude
  - chatgpt
  - gemini
  - copilot
difficulty: beginner
variables:
  - name: "document_type"
    default: "rental lease"
    description: "Type of document being analyzed"
  - name: "your_role"
    default: "tenant/customer"
    description: "Your position in the agreement"
---

# Legal Document Plain-English Analyzer

Translate complex legal documents into plain English, flag risky clauses, and get negotiation points—all without expensive attorney fees.

**Disclaimer**: This is educational analysis only, not legal advice. Consult a qualified attorney for significant contracts or disputes.

## Quick Start

Paste your contract and specify:
1. Document type (lease, service agreement, freelance contract, etc.)
2. Your role (tenant, customer, freelancer, etc.)
3. Any specific concerns

## Document Types Supported

### Consumer Contracts
- Apartment/rental leases
- Car purchase/lease agreements
- Gym memberships and subscriptions
- Cell phone and internet service agreements
- Software/SaaS terms of service

### Freelance/Business Contracts
- Freelance client agreements
- Independent contractor agreements
- NDAs and non-compete agreements
- Consulting contracts

### Employment Documents
- Job offer letters
- Employment agreements
- Severance agreements

## Analysis Framework

### 1. Plain-English Summary
Simple explanation of what you're agreeing to, what you get, what you give up, duration, and exit terms.

### 2. Money Matters
All costs identified: upfront, recurring, hidden, and penalties.

### 3. Red Flag Detection
Clauses flagged by severity:
- 🔴 Critical - May want to reject or negotiate
- 🟠 Concerning - Should understand before signing
- 🟡 Notable - Unusual but may be acceptable

### 4. Negotiation Points
Specific scripts for pushing back on problematic terms.

## Common Red Flags

### Rental Leases
- Auto-renewal traps
- Unreasonable entry rights
- Vague security deposit terms
- Full joint liability for roommates

### Service Agreements
- Hidden auto-renewal
- Unilateral price increase rights
- Cancellation penalties
- Broad data usage rights

### Freelance Contracts
- All IP assigned with no portfolio rights
- Unlimited revisions
- Payment "upon satisfaction"
- Broad non-compete clauses

## What I Need

1. **The document** (paste text or key sections)
2. **Document type**
3. **Your role**
4. **Specific concerns** (optional)

I'll translate the legalese, flag risks, and give you negotiation talking points.

---
Downloaded from [FindSkill.ai](https://findskill.ai)
