---
name: linkedin-b2b-lead-generation
version: 1.0.0
description: LinkedIn B2B Lead Generation Strategist - Master B2B lead generation on LinkedIn with ICP targeting, Sales Navigator tactics, content pillars, newsletter strategies, and sales enablement frameworks.
author: FindSkill.ai
license: MIT
---

# Initialization

## Overview

This skill provides a comprehensive framework for B2B lead generation on LinkedIn. It covers ideal customer profile (ICP) definition, Sales Navigator optimization, content pillar strategy, newsletter growth tactics, outreach sequences, and measurement frameworks.

This is a **prompt-only skill** with no scripts to generate. Simply use SKILL.md directly with your AI assistant.

**Time to initialize**: ~1 minute (just copy the prompt)

## Directory Structure

```
linkedin-b2b-lead-generation/
├── SKILL.md          # Main skill instructions (copy this to use)
└── INIT.md           # This initialization file
```

## Dependencies

None required. This is a prompt-only skill.

## Files to Generate

None. This skill works by copying the SKILL.md content directly into your AI assistant.

## Usage Instructions

### For Claude Code Users

```bash
# Option 1: Copy to your skills directory
cp -r linkedin-b2b-lead-generation/ ~/.claude/skills/linkedin-b2b-lead-generation/

# Option 2: Reference directly in conversation
# Just tell Claude to "use the linkedin-b2b-lead-generation skill"
```

### For Other AI Assistants (ChatGPT, Gemini, Copilot)

1. Open `SKILL.md`
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's chat or system prompt
4. Start describing your business and lead generation goals

## What This Skill Covers

### Core Capabilities

1. **ICP Framework**
   - Firmographic criteria definition
   - Persona development
   - Buying committee mapping
   - Anti-ICP creation

2. **Sales Navigator Mastery**
   - 30+ filter optimization
   - Boolean search techniques
   - Spotlight filters for intent signals
   - Saved searches and alerts

3. **Content Pillar Strategy**
   - 5-pillar framework for B2B
   - Content format optimization
   - Weekly/monthly content calendars
   - Content ideas generator

4. **Newsletter Strategy**
   - LinkedIn newsletter setup
   - Subscriber growth tactics
   - Lead pipeline integration
   - Conversion triggers

5. **Outreach Framework**
   - Connection request templates
   - Post-connection sequences
   - InMail best practices
   - Engagement-before-outreach strategy

6. **Sales Enablement**
   - Funnel-stage content mapping
   - Objection-handling content
   - Case study framework

7. **Measurement**
   - Leading and lagging indicators
   - Attribution models
   - Weekly review templates

## Variables to Customize

When using this skill, customize these variables:

| Variable | Default | Description |
|----------|---------|-------------|
| `{{business_model}}` | B2B SaaS | Your company type |
| `{{target_persona}}` | VP of Marketing | Primary decision-maker |
| `{{company_size}}` | 50-500 employees | Target company size |
| `{{industry}}` | Technology and Software | Target industry |

## Example Prompts

**Full Strategy Request:**
```
I run a B2B SaaS company selling marketing automation to
mid-market companies. Our target is VP of Marketing at
companies with 100-1000 employees in e-commerce.

Help me build a complete LinkedIn lead generation strategy
to generate 20+ qualified meetings per month.
```

**Content Pillar Development:**
```
I need to develop content pillars for LinkedIn. My target
audience is CFOs at manufacturing companies. What 5 pillars
should I focus on, and give me 10 post ideas for each?
```

**Sales Navigator Setup:**
```
Help me set up Sales Navigator searches for my ICP:
HR Directors at healthcare companies with 500-5000 employees
in the US. What filters and Boolean searches should I use?
```

**Outreach Sequence:**
```
I want to reach out to CTOs at fintech startups. Create a
connection request template and a 3-message follow-up
sequence that's value-first, not salesy.
```

## Compatibility

Tested and works with:
- Claude (Sonnet, Opus)
- ChatGPT (GPT-4, GPT-4o)
- Gemini Pro
- GitHub Copilot
- Any LLM that accepts system prompts

## Related Skills

This skill works well with:
- **LinkedIn Thought Leader** - Build personal authority
- **LinkedIn Engagement Strategy** - Algorithm optimization
- **LinkedIn Connection Messages** - Outreach templates
- **Cold Email Outreach Pro** - Multi-channel sequences
- **Newsletter Content Calendar** - Editorial planning

## Post-Init Steps

1. Copy SKILL.md content to your preferred AI assistant
2. Share your business context (model, target, current state)
3. Get customized strategy, templates, and execution plan
4. Implement the 30-day plan
5. Track metrics and iterate

## Support

For questions or updates, visit [FindSkill.ai](https://findskill.ai)

---
Downloaded from [Find Skill.ai](https://findskill.ai)
