---
name: linkedin-narrative-builder
version: 1.0.0
---

# Initialization

LinkedIn Narrative Builder - Transform your LinkedIn profile into a compelling career story using the Hero's Journey framework and psychological storytelling principles. Build authentic personal brand narratives that create emotional connections and attract opportunities.

## Structure

This skill contains:
- `SKILL.md` - Main skill prompt with Hero's Journey framework, headline formulas, content templates, and workflows

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Dependencies

None

## Post-Init Steps

### Claude Code
```bash
cp -r linkedin-narrative-builder/ ~/.claude/skills/linkedin-narrative-builder/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after the frontmatter (starting from "You are a LinkedIn Narrative Builder...")
3. Paste into your AI assistant

## Compatibility

Tested with: claude, chatgpt, gemini, copilot

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{target_audience_type}}` | `Recruiters` | Who you want to attract (Recruiters, Clients, Industry Peers, C-suite Partners) |
| `{{primary_emotion_theme}}` | `Inspiration` | Core emotional resonance (Inspiration, Empathy, Admiration, Transformation, Authority) |
| `{{career_stage_context}}` | `Mid-Career Transition` | Your career phase (Early Career, Mid-Career Transition, Executive Level, Founder, Freelancer) |
| `{{narrative_style_preference}}` | `Hero's Journey` | Primary storytelling framework (Hero's Journey, Problem-Solution, Before-After, Lessons Learned) |
| `{{content_update_frequency}}` | `2-3 per week` | Posting cadence (Daily, 3-5 per week, 2-3 per week, Weekly) |
| `{{visual_content_preference}}` | `Moderate` | Multimedia level (Text-heavy, Moderate, Video-forward, Multi-media Rich) |

## Key Features

### Hero's Journey Framework
Maps Joseph Campbell's 12-stage narrative structure to LinkedIn profile sections:
- Ordinary World → Background
- Call to Adventure → Career Trigger
- Road of Trials → Challenges Overcome
- Transformation → Growth Story
- Return with Elixir → Value You Offer

### Headline Formulas
- **PPP Formula**: Position + Passion + Purpose
- **Achievement-Led**: Role | Result | Approach
- **Transformation-Led**: Former Role → Current Role | Value
- **Mission-Led**: Role | Mission | Expertise
- **Audience-Led**: Helping [Who] [Achieve What] | [How]

### Content Frameworks
- **Problem-Struggle-Solution-Lesson**: For LinkedIn posts
- **Hook Formulas**: Counterintuitive, Question, Curiosity Gap, Paradox, Confession
- **Career Arc Mapping**: Connect past to present to future

### Workflows Included
1. Complete Profile Narrative Redesign
2. Career Transition Narrative
3. LinkedIn Post Content Series
4. Personal Brand Consolidation
5. Executive Thought Leadership Authority

## Example Usage

```
"I'm transitioning from enterprise software sales (10 years) to product management.
I have an MBA in Product Management but interviewers keep seeing me as a 'sales person.'
Help me craft my LinkedIn profile narrative using the Hero's Journey to show this is
intentional growth, not a lateral move. My target audience is tech product teams at
Series B-D startups. My core emotion should be 'transformation.' What should my headline,
summary, and featured section look like?"
```

## Research Sources

- The Power of Branding and Storytelling on LinkedIn
- How to Use the Hero's Journey to Craft Your Personal Brand Story
- Psychological Storytelling and LinkedIn Content Strategy (Academic Research)
- Tales of Me: Storytelling Identity Work and Authenticity
- Building Your Brand Story Using the Hero's Journey Framework

---
Downloaded from [Find Skill.ai](https://findskill.ai)
