---
name: localization-readiness-auditor
version: 1.0.0
---

# Localization Readiness Auditor - Initialization

Evaluate software internationalization readiness with comprehensive technical, organizational, and compliance assessments for successful global market expansion.

## What This Skill Does

The Localization Readiness Auditor assesses whether your software product has the foundation for international expansion across five dimensions:

1. **Technical Infrastructure** - String externalization, UTF-8 encoding, UI flexibility, RTL support, locale-aware formatting
2. **Content Readiness** - Content inventory, translation quality, content structure
3. **Process Maturity** - Workflow design, technology stack, team structure, vendor management
4. **Compliance & Legal** - Data privacy (GDPR, CCPA), legal content, content restrictions
5. **Market Strategy** - Market research, go-to-market planning, success metrics

## Structure

```
localization-readiness-auditor/
├── SKILL.md    # Main skill prompt (copy to AI assistant)
└── INIT.md     # This initialization file
```

## Files to Generate

None (prompt-only skill)

## Installation

### Claude Code

```bash
# Copy the skill directory to your Claude Code skills folder
cp -r localization-readiness-auditor/ ~/.claude/skills/localization-readiness-auditor/
```

Then reference in your project's `.claude/settings.json` or use directly.

### Other AI Assistants (ChatGPT, Gemini, Copilot)

1. Open `SKILL.md`
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into your AI assistant as a system prompt or conversation starter
4. Begin your audit request

## Quick Start

After installation, start with a prompt like:

```
Audit our e-commerce platform for internationalization readiness.
We're targeting Germany, France, and Japan within 6 months.
Tech stack: Next.js frontend, Python/Django backend, PostgreSQL.
Currently English-only, no prior localization experience.
```

The AI will gather additional context and provide a comprehensive assessment.

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{target_languages}}` | `["en", "es", "de", "fr"]` | ISO 639-1 language codes for markets under assessment |
| `{{assessment_scope}}` | `full_stack` | Options: technical_only, content_only, organizational, full_stack |
| `{{market_priority_level}}` | `high` | Options: high, medium, low - affects depth of analysis |
| `{{current_maturity_stage}}` | `planning` | Options: planning, initial, developing, optimizing |
| `{{include_compliance_audit}}` | `true` | Whether to assess GDPR, CCPA, local privacy laws |
| `{{budget_constraint_usd}}` | `null` | Optional budget limit to filter recommendations |

## Example Assessments

### Pre-Launch Technical Audit
```
Audit our project management SaaS for i18n readiness.
We want to launch in DACH region (Germany, Austria, Switzerland) in Q2.
React frontend, Node.js backend, MongoDB.
Need to identify blocking issues and estimate remediation effort.
```

### Existing Product Expansion
```
We've localized into 8 languages but conversion rates are struggling
in Brazil and Mexico (2-3% vs 8-10% in Germany/UK).
Audit our Portuguese and Spanish localizations for quality issues.
```

### Enterprise Capability Assessment
```
Our financial services company is planning expansion into 15 Asian markets.
We have basic translation but inconsistent processes.
Need organizational readiness assessment: governance, staffing, tooling, compliance.
```

## Key Concepts

- **i18n (Internationalization)**: Technical infrastructure for multilingual support
- **l10n (Localization)**: Adapting content for specific markets
- **g11n (Globalization)**: Umbrella strategy encompassing i18n + l10n + business
- **String Externalization**: Separating text from code into resource files
- **UTF-8**: Universal character encoding for all languages
- **RTL**: Right-to-left language support (Arabic, Hebrew, Persian)
- **Text Expansion**: German runs 20-25% longer than English
- **TMS**: Translation Management System (Crowdin, Lokalise, Phrase)
- **LSP**: Language Service Provider (translation vendor)

## Output Format

The audit produces:

1. **Executive Summary** - Overall score (1-100), key findings, blockers
2. **Dimension Scores** - 1-5 rating per dimension with weighted total
3. **Detailed Findings** - Gaps, risks, evidence per dimension
4. **Remediation Roadmap** - Prioritized fixes with effort estimates
5. **Resource Requirements** - Team, tools, vendors, budget
6. **Success Metrics** - Milestones and KPIs

## Related Skills

- [Market Expansion Feasibility](/skills/productivity/market-expansion-feasibility/)
- [Go-To-Market Strategy Creator](/skills/productivity/go-to-market-strategy-creator/)
- [GDPR Request Processor](/skills/industry/gdpr-request-processor/)
- [Vendor Risk Assessment](/skills/industry/vendor-risk-assessment/)

---

Downloaded from [Find Skill.ai](https://findskill.ai)
