---
name: major-purchase-advisor
version: 1.0.0
description: Expert guidance on major purchases with product comparisons and discount strategies
author: FindSkill.ai
license: MIT
---

# Initialization

Help consumers make informed buying decisions on major purchases through comprehensive product comparisons, feature analysis, and discount-finding tactics.

## Overview

This is a prompt-only skill with no scripts to generate. The skill provides:
- Product comparison frameworks
- Best times to buy by category
- Discount code discovery strategies
- Decision support for buy-now vs wait

**Time to initialize**: Immediate (no setup required)

## Directory Structure

```
major-purchase-advisor/
├── SKILL.md    # Main skill instructions
└── INIT.md     # This file
```

## Dependencies

None required.

## Files to Generate

None (prompt-only skill).

## Post-Init Steps

### Claude Code
```bash
# Copy to your skills directory
cp -r major-purchase-advisor/ ~/.claude/skills/major-purchase-advisor/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy the content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt or chat

## Compatibility

Tested with: claude, chatgpt, gemini, copilot

## Variables

Customize these in your requests:

| Variable | Default | Description |
|----------|---------|-------------|
| `product_category` | `` | Type of product (TV, refrigerator, car, etc.) |
| `budget_range` | `` | Price range (min-max) |
| `must_have_features` | `` | Essential features required |
| `use_case` | `` | Primary use scenario |
| `timeline` | `flexible` | When purchase is needed |

## Example Usage

```
I need to buy a new refrigerator for a family of 4. Budget is $1,500-2,500.
Must have: French doors, ice maker, at least 25 cubic feet.
Looking to buy within the next month during holiday sales.
Help me research and compare the best options.
```

## Key Features

### Supported Categories
- Electronics (TVs, laptops, phones)
- Major appliances
- Vehicles (new and used)
- Home goods and furniture
- Technology and smart home

### Analysis Provided
- Product specification comparisons
- Price history and deal timing
- Expert and user review summaries
- Total cost of ownership
- Warranty and reliability data

### Discount Strategies
- Browser extension recommendations
- Coupon site resources
- Cart abandonment tactics
- Price matching tips
- Sale timing calendars

---
Downloaded from [Find Skill.ai](https://findskill.ai)
