---
name: meeting-cost-calculator
version: 1.0.0
description: Calculate true cost of meetings based on salaries, duration, and overhead
author: FindSkill.ai
license: MIT
---

# Initialization

## Overview

Prompt-only skill for meeting cost analysis. No scripts required.

**What it does:**
- Calculates direct salary cost
- Adds overhead/benefits (loaded cost)
- Projects annual recurring costs
- Analyzes meeting ROI
- Suggests optimizations

**Time to initialize:** Instant

## Directory Structure

```
meeting-cost-calculator/
├── SKILL.md
└── INIT.md
```

## Dependencies

None

## Post-Init Steps

### Claude Code Users
```bash
cp -r meeting-cost-calculator/ ~/.claude/skills/meeting-cost-calculator/
```

### Other AI Assistants
Copy SKILL.md content into your AI assistant.

## Usage Example

```
Calculate the cost of our weekly leadership sync:

Duration: 1.5 hours
Frequency: Weekly

Attendees:
- CEO: $350,000/year
- CFO: $280,000/year
- CTO: $300,000/year
- VP Product: $220,000/year
- VP Sales: $240,000/year

Include overhead and annual projection.
```

---
Downloaded from [FindSkill.ai](https://findskill.ai)
