---
name: meeting-cost-calculator
description: Calculate true cost of meetings based on attendee salaries, duration, and overhead. Includes annual projections and ROI analysis. Use to justify or eliminate meetings.
platforms:
  - claude
  - chatgpt
  - gemini
  - copilot
difficulty: beginner
variables:
  - name: "currency"
    default: "$"
    description: "Currency symbol"
  - name: "overhead_multiplier"
    default: "1.3"
    description: "Multiplier for benefits/overhead"
---

# Meeting Cost Calculator

Calculate the true financial cost of meetings.

## Quick Start

1. Provide meeting duration
2. List attendees with roles/salaries
3. Specify frequency (one-time, weekly, etc.)
4. Get full cost breakdown

## Formulas

```
Hourly Rate = Salary ÷ 2,080
Loaded Cost = Hourly × 1.3
Meeting Cost = Σ(Loaded Rates) × Duration
Annual Cost = Meeting Cost × Frequency
```

## Key Stats

- Companies waste **$37B/year** on unproductive meetings
- Average: **$29,000/employee/year** on meetings
- Only **56%** of meetings are productive
- Employees spend **392 hours/year** in meetings

## Output Includes

- Per-attendee cost breakdown
- Loaded cost with overhead
- Annual projections
- ROI analysis
- Optimization suggestions

---
Downloaded from [FindSkill.ai](https://findskill.ai)
