---
name: meeting-decline-diplomat
version: 1.0.0
description: Decline meeting invitations professionally without burning bridges
author: FindSkill.ai
license: MIT
---

# Initialization

## Overview

This skill helps professionals decline meeting invitations diplomatically while protecting their time and maintaining positive relationships with colleagues and leadership.

**Time to initialize**: ~1 minute (prompt-only skill)

## Directory Structure

```
meeting-decline-diplomat/
├── SKILL.md    # Main skill instructions
└── INIT.md     # This initialization file
```

## Dependencies

None (prompt-only skill)

## What This Skill Covers

### Decline Templates For
- Generic polite declines
- Low-value/optional meetings
- Recurring meeting reduction
- Senior leader meetings
- "Just in case" invites
- Calendar block conflicts

### Strategies Included
- Meeting value assessment framework
- Alternative participation options
- Handling pushback gracefully
- Special situations (boss, new employee)

## Usage Instructions

### For Claude Code

```bash
cp -r meeting-decline-diplomat/ ~/.claude/skills/meeting-decline-diplomat/
```

### For Other AI Assistants

1. Open `SKILL.md`
2. Copy content after frontmatter
3. Paste into your AI assistant

## Example Request

```
I've been invited to a weekly 'sync' meeting that's 90 minutes long
with 15 people. I don't really need to be there - they just CC everyone.
But the organizer is a senior director and I don't want to seem like
I'm not a team player. How do I decline without offending anyone?
```

## Compatibility

Tested with: Claude, ChatGPT, Gemini, Copilot

---
Downloaded from [Find Skill.ai](https://findskill.ai)
