---
name: meeting-notes-action-extractor
version: 1.0.0
description: Transform meeting transcripts into structured summaries and action items
author: FindSkill.ai
license: MIT
---

# Initialization

Transform messy meeting transcripts into clear summaries, tracked action items, and professional follow-up emails. Never let important decisions or tasks slip through the cracks again.

## Overview

This is a prompt-only skill that processes meeting content to extract decisions, action items, and create follow-up communications. No scripts or additional files are required.

**Time to initialize**: Instant (no setup required)

## Directory Structure

```
meeting-notes-action-extractor/
├── SKILL.md    # Main skill prompt
└── INIT.md     # This file
```

## Dependencies

None - this is a prompt-only skill.

## Files to Generate

None - simply use SKILL.md directly.

## Post-Init Steps

### Claude Code
```bash
# Copy to your skills directory
cp -r meeting-notes-action-extractor/ ~/.claude/skills/meeting-notes-action-extractor/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy the content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt or chat

## Compatibility

Tested with: Claude, ChatGPT, Gemini, Copilot

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `transcript` | (empty) | The meeting transcript or notes to process |
| `meeting_type` | general | Type of meeting (standup, planning, review, client, 1:1) |
| `output_format` | all | Desired output (summary, action items, follow-up email, all) |
| `team_context` | (empty) | Team or project context for better extraction |

## Use Cases

This skill excels at:

### For Managers
- Processing 1:1 meeting notes
- Creating team meeting summaries
- Tracking commitments across meetings
- Drafting status update emails

### For Project Leads
- Sprint planning documentation
- Retrospective action tracking
- Stakeholder meeting follow-ups
- Decision logs maintenance

### For Executive Assistants
- Board meeting minutes
- Leadership meeting summaries
- Investor call documentation
- Cross-functional meeting coordination

### For Remote Teams
- Async meeting documentation
- Time zone-friendly summaries
- Searchable meeting archives
- Accountability tracking

## Input Sources

The skill works with content from:
- **Transcription services**: Otter.ai, Rev, Fireflies.ai, Grain
- **Video platforms**: Zoom, Teams, Google Meet transcripts
- **Manual notes**: Handwritten notes typed up, real-time notes
- **Recording summaries**: AI-generated summaries from recording tools

## Example Workflow

1. **After meeting**: Paste transcript into AI with this skill
2. **Get outputs**: Receive summary, action items, follow-up email
3. **Distribute**: Send follow-up email to attendees
4. **Track**: Add action items to project management tool
5. **Archive**: Save summary for future reference

## Integration Tips

### With Project Management Tools
Export action items in formats compatible with:
- Jira (can request Jira markdown format)
- Asana (task list format)
- Linear (markdown format)
- Notion (markdown or database format)

### With Calendar Apps
Request next meeting details to add to calendar invites.

### With Communication Tools
Follow-up email can be sent directly via Slack, Teams, or email.

---
Downloaded from [FindSkill.ai](https://findskill.ai)
