---
name: meeting-to-slack-digest
version: 1.0.0
description: Convert meeting notes into Slack/Teams channel updates with TL;DR and emoji formatting
author: FindSkill.ai
license: MIT
---

# Initialization

## Overview

This is a prompt-only skill for converting meeting notes into channel-friendly updates. No scripts required.

**What it does:**
- Creates TL;DR summaries
- Formats with emoji status indicators
- Structures action items with owners/dates
- Generates thread content for details
- Adapts for Slack or Microsoft Teams

**Time to initialize:** Instant

## Directory Structure

```
meeting-to-slack-digest/
├── SKILL.md    # Main skill instructions
└── INIT.md     # This file
```

## Dependencies

None - prompt-only skill.

## Files to Generate

None required.

## Post-Init Steps

### For Claude Code Users
```bash
cp -r meeting-to-slack-digest/ ~/.claude/skills/meeting-to-slack-digest/
```

### For Other AI Assistants
1. Open `SKILL.md`
2. Copy content after frontmatter
3. Paste into your AI assistant

## Usage Examples

### Basic Usage
```
Convert this to a Slack update for #product-team:

Sprint Planning meeting - discussed checkout redesign,
blocked on payment API, launching Sept 1 instead of Aug 15.
Sarah owns design, Mike handles API escalation.
```

### Urgent Update
```
Create an urgent Slack update (use @here):

Critical bug found in production payments.
Team meeting decided to rollback immediately.
Mike leading incident response.
```

## Compatibility

Works with: Claude, ChatGPT, Gemini, Copilot

---
Downloaded from [FindSkill.ai](https://findskill.ai)
