---
name: meeting-to-slack-digest
description: Convert meeting notes into punchy Slack/Teams channel updates with TL;DR, emoji status, and action items. Use when you need to share meeting outcomes with a channel quickly.
platforms:
  - claude
  - chatgpt
  - gemini
  - copilot
difficulty: beginner
variables:
  - name: "channel_name"
    default: "#engineering-updates"
    description: "Target Slack/Teams channel"
  - name: "audience"
    default: "engineering team"
    description: "Who will read this update"
  - name: "urgency_level"
    default: "routine"
    description: "routine, important, or critical"
---

# Meeting to Slack Digest

Transform meeting notes into scannable channel updates that teams actually read.

## Quick Start

1. Paste your meeting notes
2. Specify target channel and audience
3. Get copy-paste ready Slack/Teams message

## Output Format

```
📋 *Meeting Recap: [Name]* | [Date]

*TL;DR:* [Key outcome in one sentence]

───────────────────

*🎯 Decisions*
• [Decision 1] — @owner
• [Decision 2] — @owner

*📌 Action Items*
• [ ] @sarah: [Task] — Due: [Date]
• [ ] @mike: [Task] — Due: [Date]

*🔴 Blockers*
• [Blocker] — Escalated to: @name

───────────────────
_Full notes in thread ↓_
```

## Status Emoji Reference

| Status | Emoji |
|--------|-------|
| On track | 🟢 |
| Minor issues | 🟡 |
| Blocked | 🔴 |
| Complete | ✅ |
| Urgent | 🚨 |

## Message Types

- **Standard** - Full recap with decisions and actions
- **Quick** - 3-line summary for routine meetings
- **Urgent** - @here with immediate action needed
- **Status** - Project health with emoji indicators

## Best Practices

- Keep main message under 15 lines
- Put detailed notes in thread
- Use @here sparingly (urgent only)
- Post within 1 hour of meeting

---
Downloaded from [FindSkill.ai](https://findskill.ai)
