---
name: meeting-transcript-fixer
version: 1.0.0
description: Clean up AI-generated meeting transcripts - fix names, jargon, filler words, merge segments
author: FindSkill.ai
license: MIT
---

# Initialization

## Overview

This is a prompt-only skill for cleaning up AI-generated meeting transcripts. No scripts or external dependencies required.

**What it does:**
- Fixes misspelled participant names
- Corrects misheard technical jargon and acronyms
- Removes filler words (um, uh, like, you know)
- Merges fragmented speaker segments
- Standardizes speaker labels
- Improves punctuation and formatting

**Time to initialize:** Instant (no setup required)

## Directory Structure

```
meeting-transcript-fixer/
├── SKILL.md    # Main skill instructions
└── INIT.md     # This file
```

## Dependencies

None - this is a prompt-only skill.

## Files to Generate

None required. Simply use the SKILL.md content directly.

## Post-Init Steps

### For Claude Code Users
```bash
# Copy to your skills directory
cp -r meeting-transcript-fixer/ ~/.claude/skills/meeting-transcript-fixer/
```

### For Other AI Assistants
1. Open `SKILL.md`
2. Copy the content (everything after the frontmatter `---`)
3. Paste into your AI assistant's system prompt or chat

## Usage Examples

### Basic Usage
```
Clean up this meeting transcript:

[00:01:23] Speaker 1: So, um, I think we should, uh, look at the...
[00:01:28] Speaker 1: ...the conversion metrics from last week.

Participants: Sarah Chen, Mike O'Brien
```

### With Technical Terms
```
Fix this transcript. Technical terms: OKRs, Kubernetes, CI/CD, AWS Lambda

[Paste transcript here]
```

### Heavy Cleanup (Prose Format)
```
Clean this transcript using heavy cleanup level (convert to prose):

[Paste transcript here]
```

## Compatibility

Tested with:
- Claude (claude.ai, Claude Code)
- ChatGPT (GPT-4, GPT-4o)
- Gemini (Pro, Ultra)
- GitHub Copilot Chat
- Any LLM with conversation capability

## Variables

Customize these when using the skill:

| Variable | Default | Description |
|----------|---------|-------------|
| `participant_names` | Sarah Chen, Mike O'Brien, Dr. Patel | Correct spelling of participants |
| `company_terms` | OKRs, Kubernetes, AWS Lambda | Industry/company jargon |
| `cleanup_level` | standard | light, standard, or heavy |

## Transcript Source Compatibility

Works with transcripts from:
- Zoom automatic transcription
- Microsoft Teams transcripts
- Otter.ai exports
- OpenAI Whisper output
- Google Meet transcripts
- Rev.ai transcripts
- Any speech-to-text output

## Tips for Best Results

1. **Always provide participant names** - Most critical for accuracy
2. **Include your company glossary** - Prevents jargon errors
3. **Specify cleanup level** - Heavy for external sharing, light for internal notes
4. **Flag sensitive content** - Mark off-record discussions before cleanup

---
Downloaded from [FindSkill.ai](https://findskill.ai)
