---
name: meeting-transcript-fixer
description: Clean up AI-generated meeting transcripts by fixing names, jargon, filler words, and fragmented segments. Use when you have raw transcripts from Zoom, Teams, Otter, Whisper, or any speech-to-text tool that need polishing before sharing.
platforms:
  - claude
  - chatgpt
  - gemini
  - copilot
difficulty: beginner
variables:
  - name: "participant_names"
    default: "Sarah Chen, Mike O'Brien, Dr. Patel"
    description: "Correct spelling of all meeting participants"
  - name: "company_terms"
    default: "OKRs, Kubernetes, AWS Lambda"
    description: "Company-specific terms and acronyms"
  - name: "cleanup_level"
    default: "standard"
    description: "light, standard, or heavy cleanup"
---

# Meeting Transcript Fixer

Transform messy AI-generated transcripts into polished, readable documents.

## Quick Start

1. Paste your raw transcript
2. Provide participant names (correct spelling)
3. List any technical terms/acronyms
4. Choose cleanup level: light | standard | heavy

## What Gets Fixed

### Name Errors
AI mishears names as common words:
- "sarah chen" → "Sara Shen" → **Sarah Chen**
- "mike o'brien" → "Mike O Brien" → **Mike O'Brien**

### Technical Jargon
Industry terms become nonsense:
- "okay ours" → **OKRs**
- "kuber nets" → **Kubernetes**
- "see I see D" → **CI/CD**
- "a pie" → **API**

### Filler Words
Remove the noise:
- "um", "uh", "er", "ah"
- "like", "you know", "basically"
- False starts and repeated words

### Fragmented Segments
Merge split speaker turns:
```
Before:
[00:01:23] Speaker 1: So I think we...
[00:01:28] Speaker 1: ...should look at metrics.

After:
[00:01:23] Sarah Chen: I think we should look at metrics.
```

## Cleanup Levels

| Level | What Happens |
|-------|--------------|
| Light | Fix names, obvious errors, keep timestamps |
| Standard | Remove all fillers, merge segments, clean punctuation |
| Heavy | Convert to prose paragraphs, publication-ready |

## Example Output

```markdown
# Meeting Transcript (Cleaned)

**Participants:** Sarah Chen, Mike O'Brien, Dr. Patel
**Cleanup Level:** Standard

---

[00:00:15] **Sarah Chen:** Let's start with the Q3 roadmap updates.
I've been reviewing the OKRs and we're tracking well on the
authentication refactor.

[00:00:45] **Mike O'Brien:** The Kubernetes migration is about 70%
complete. We should hit our target by end of month.
```

## Uncertainty Handling

| Situation | Notation |
|-----------|----------|
| Unclear word | [inaudible] |
| Possible name | Name [?] |
| Ambiguous number | 15 [or 50?] |
| Unknown term | term [verify] |

## Usage Tips

1. **Always provide participant names** - prevents 90% of name errors
2. **Include your glossary** - technical terms specific to your company
3. **Note the audio source** - Zoom/Teams/Otter have different error patterns
4. **Flag sensitive sections** - mark off-record discussions

---
Downloaded from [FindSkill.ai](https://findskill.ai)
