---
name: mental-wellness-companion
version: 1.0.0
description: CBT-inspired journaling, anxiety management, cognitive reframing, and mood tracking support
author: FindSkill.ai
license: MIT
---

# Initialization

This skill transforms AI into a Mental Wellness Companion that provides CBT-inspired techniques, guided journaling exercises, anxiety management strategies, and mood tracking—offering accessible support for everyday emotional wellness.

## Overview

**What this skill does:**
- Provides CBT-inspired thought examination and reframing
- Offers guided journaling exercises for different emotional needs
- Teaches anxiety management techniques (grounding, breathing, worry containment)
- Supplies mood tracking templates with pattern recognition
- Delivers self-care planning across multiple life dimensions
- Adapts to three support styles: gentle, direct, or structured

**Time to initialize**: ~1 minute (prompt-only skill)

## Directory Structure

```
mental-wellness-companion/
├── SKILL.md    # Main skill instructions
└── INIT.md     # This initialization file
```

## Dependencies

None (prompt-only skill)

## Files to Generate

None - this is a prompt-only skill. Copy SKILL.md content directly to your AI assistant.

## Post-Init Steps

### For Claude Code Users
```bash
# Copy to your skills directory
cp -r mental-wellness-companion/ ~/.claude/skills/mental-wellness-companion/
```

### For Other AI Assistants
1. Open `SKILL.md`
2. Copy the content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt or chat
4. Optionally: Create a dedicated "Wellness" thread for context retention

## Compatibility

Tested with: Claude, ChatGPT, Gemini, Copilot

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{current_feeling}}` | "" | Current emotional state or concern |
| `{{journal_type}}` | "reflection" | Type of journaling exercise |
| `{{support_style}}` | "gentle" | Preferred approach (gentle, direct, structured) |

## Example Usage

**Processing anxiety:**
> "I've been really anxious about a presentation at work next week. I keep imagining everything going wrong. Can you help me work through this?"

**Journaling exercise:**
> "I want to do some journaling to process my day. I had a conflict with a friend and I'm feeling hurt and confused."

**Thought examination:**
> "I keep thinking 'I'm not good enough for this job' even though I've been here for 2 years. Help me examine this thought."

**Mood tracking:**
> "Can you give me a mood tracking template? I want to start tracking my mental health patterns."

**Self-compassion:**
> "I made a mistake at work and I can't stop beating myself up about it. I need help being kinder to myself."

## Key Features

1. **CBT-based thought work** - ABCDE method, cognitive distortion identification
2. **Multiple journaling types** - Morning intention, evening reflection, emotional processing, anxiety-specific, self-compassion
3. **Anxiety toolkit** - Grounding (5-4-3-2-1), box breathing, worry window, reframe questions
4. **Mood tracking** - Daily check-in template, weekly pattern review
5. **Self-care planning** - Physical, emotional, social, intellectual, spiritual dimensions
6. **Flexible support styles** - Gentle, direct, or structured based on preference

## Safety Features

This skill includes important safety guardrails:
- Clear disclaimer that it's not therapy
- Always recommends professional help for clinical concerns
- Crisis resources prominently displayed (988, Crisis Text Line)
- Never attempts to diagnose conditions
- Validates feelings without pathologizing

## Research Foundation

This skill is built on evidence-based approaches:
- **Cognitive Behavioral Therapy (CBT)** - Gold standard for anxiety and depression
- **Therapeutic journaling** - Research shows reduction in anxiety and depressive symptoms
- **Mindfulness techniques** - Grounding exercises from MBCT
- **Self-compassion frameworks** - From Kristin Neff's research

Studies show:
- Journaling 2x/week reduces anxiety significantly (Western Michigan University)
- CBT chatbots meaningfully reduce anxiety and depression symptoms (Woebot/Stanford)
- 73% of adults report anxiety/depression symptoms (highlighting need for accessible support)

## Verification

To verify the skill is working correctly:
1. Share a feeling or situation
2. Confirm you receive validation first (not immediately jumping to solutions)
3. Confirm you receive appropriate techniques for your situation
4. Confirm crisis resources are mentioned when appropriate

---

Downloaded from [FindSkill.ai](https://findskill.ai)
