---
name: mentorship-relationship-formalizer
version: 1.0.0
---

# Initialization

Transform informal mentoring into structured, goal-driven partnerships with clear expectations, accountability mechanisms, and measurable outcomes. This skill helps mentors, mentees, and program managers formalize relationships using evidence-based frameworks including SMART goals, structured session agendas, mentor-mentee matching assessments, and Kirkpatrick evaluation models.

## Structure

This skill contains:
- `SKILL.md` - Main skill prompt with comprehensive instructions for formalizing mentorship relationships

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Dependencies

None

## Post-Init Steps

### Claude Code
```bash
cp -r mentorship-relationship-formalizer/ ~/.claude/skills/mentorship-relationship-formalizer/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after the frontmatter (everything below the second `---`)
3. Paste into your AI assistant

## Compatibility

Tested with: claude, chatgpt, gemini, copilot

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{meeting_frequency}}` | `monthly` | Cadence for mentor-mentee check-ins (weekly, biweekly, monthly, quarterly) |
| `{{goals_per_cycle}}` | `3` | Number of SMART goals per review cycle (2-5) |
| `{{session_duration_minutes}}` | `60` | Recommended length of mentoring check-in (30, 45, 60, 90) |
| `{{initial_matching_method}}` | `algorithmic` | Method for pairing mentors with mentees (manual, self_selection, algorithmic, smart_match) |
| `{{feedback_loop_interval_weeks}}` | `12` | Frequency of formal feedback assessment in weeks |
| `{{question_complexity_level}}` | `intermediate` | Difficulty of guiding questions (foundational, intermediate, advanced) |
| `{{documentation_system}}` | `shared_platform` | Tool used for tracking session notes and goals |

## Core Capabilities

1. **Mentor-Mentee Matching Assessment** - Evaluate compatibility using supplementary fit (similarity-based) and complementary fit (gap-filling) criteria with scoring framework

2. **Structured Goal Setting** - Apply SMART framework for mentorship objectives with documentation templates and progress tracking

3. **Session Agenda Planning** - Comprehensive 60-minute meeting templates with segments for check-in, progress review, challenge exploration, feedback, and action planning

4. **Strategic Question Generation** - Coaching questions organized by complexity level (foundational, intermediate, advanced) for guided inquiry

5. **Formal Agreement Creation** - MOU templates covering responsibilities, meeting structure, confidentiality, and relationship closure terms

6. **Relationship Quality Assessment** - Mentor Behavioral Interaction (MBI) rubric with six dimensions for evaluating mentor effectiveness

7. **Impact Measurement** - Kirkpatrick Evaluation Framework for measuring satisfaction, learning, behavior change, and organizational results

## Example Usage

"I'm transitioning from individual contributor to a management role at a tech company. I need help structuring a mentorship relationship where I can develop leadership skills and learn how to influence cross-functional teams. Can you help me formalize a mentoring partnership with monthly check-ins, SMART goals focused on strategic thinking and stakeholder management, and create a structured session agenda template we can use for our meetings?"

## Related Skills

- **Goal Framework Strategist** - SMART goal formulation and OKR frameworks
- **Performance Review Generator** - Performance tracking and feedback documentation
- **Feedback Request Generator** - Structured feedback solicitation
- **Interview Coach** - Coaching methodology and question frameworks
- **Career Pivot Risk Calculator** - Career transition planning
- **Managing Up Communication Coach** - Relationship management skills

## Research Sources

- Enhancing Research Capacity: Structured Mentorship Framework (InnovaPath)
- Feedback Framework Development Using Activity Theory (AJHPE)
- Formal Mentoring Programs: Characteristics and Outcomes (UEN Press)
- How to Structure an Effective Mentoring Programme (Association of Business Mentors)
- Monthly Mentorship Check-In Checklist (LinkedIn)
- Mentoring Framework: The Mentorship Loop (Together Platform)
- 10 Successful Mentoring Program Best Practices (Chronus)
- Mentor-Mentee Matching Guide (Qooper)
- 15 Strategic Questions To Ask Your Mentor (Qooper)
- Measuring Mentoring: Scale Development and Validation (PMC)

---
Downloaded from [Find Skill.ai](https://findskill.ai)
