---
name: mermaid-diagrams
version: 1.0.0
---

# Initialization

Generate professional flowcharts, sequence diagrams, ERDs, and more using Mermaid syntax. Perfect for documentation, architecture planning, and technical communication.

## Structure

This skill contains:
- `SKILL.md` - Main skill prompt with instructions

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Dependencies

None

## Post-Init Steps

### Claude Code
```bash
# Copy to your skills directory
cp -r mermaid-diagrams/ ~/.claude/skills/mermaid-diagrams/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy the content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt or chat

## Compatibility

Tested with: claude, chatgpt, gemini, copilot

## Variables

Customize these placeholders in the skill:

| Variable | Default | Description |
|----------|---------|-------------|
| `{{diagram_type}}` | `flowchart` | Type of diagram to generate |
| `{{direction}}` | `TD` | Flow direction (TD, LR, BT, RL) |

## Related Skills

- [Readme Generator](https://findskill.ai/skills/claude-code/readme-generator/)
- [Code Documentation Generator](https://findskill.ai/skills/claude-code/code-documentation-generator/)

---
Downloaded from [Find Skill.ai](https://findskill.ai)