---
name: money-anxiety-decoder
version: 1.0.0
---

# Initialization

**Money Anxiety Decoder** - An AI-powered diagnostic and intervention tool that helps users identify the root psychological source of their financial anxiety (scarcity, control, shame, or uncertainty) and provides targeted, evidence-based relief strategies using CBT, ACT, and financial therapy frameworks.

## Structure

This skill contains:
- `SKILL.md` - Main skill prompt with comprehensive instructions for financial anxiety diagnosis and intervention

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Dependencies

None

## Post-Init Steps

### Claude Code
```bash
cp -r money-anxiety-decoder/ ~/.claude/skills/money-anxiety-decoder/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after the frontmatter (everything below the second `---`)
3. Paste into your AI assistant's system prompt or conversation

## Compatibility

Tested with: claude, chatgpt, gemini, copilot

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{anxiety_depth_level}}` | `standard` | Assessment depth: quick (8 questions), standard (12-15), or intensive (20+) |
| `{{strategy_intensity}}` | `moderate` | Intervention intensity: gentle, moderate, or intensive |
| `{{time_available_weekly}}` | `15_min` | Available practice time: 5_min, 15_min, 30_min, or 60_min |
| `{{previous_therapy_experience}}` | `none` | Mental health background: none, some_reading, or therapy_experience |
| `{{cultural_money_context}}` | `general` | Cultural adaptation for money scripts and beliefs |
| `{{focus_pattern}}` | `auto_detect` | Which pattern to prioritize: auto_detect, scarcity, control, shame, or uncertainty |

## Core Capabilities

1. **Anxiety Pattern Assessment** - 12-15 question diagnostic identifying dominant pattern across four axes (scarcity, control, shame, uncertainty) with 0-100 scoring
2. **Money History Excavation** - Guided exploration of childhood money experiences, family patterns, and triggering events to understand anxiety origins
3. **Personalized Relief Strategies** - Pattern-matched interventions at gentle/moderate/intensive levels including gratitude practices, thought records, micro-exposure, and acceptance exercises
4. **CBT Thought Records** - 7-step process for identifying, challenging, and restructuring automatic negative thoughts about money
5. **Progress Tracking** - Weekly check-ins comparing anxiety scores to baseline, identifying what works, and building early warning systems

## Four Anxiety Patterns

| Pattern | Core Fear | Manifestation | Key Intervention |
|---------|-----------|---------------|------------------|
| **Scarcity** | Never having enough | Hoarding, guilt spending, catastrophizing | Evidence gathering, abundance reframing |
| **Control** | Losing power | Compulsive checking, hypervigilance | Control inventory, single contingency plan |
| **Shame** | Being judged | Avoidance, secrecy, perfectionism | Self-compassion, micro-exposure |
| **Uncertainty** | The unknown | Overwhelm, paralysis, vague dread | Information gathering, scenario planning |

## Evidence Base

This skill draws from:
- Shapiro & Burchell Financial Anxiety Scale
- Psychological Inventory of Financial Scarcity (PIFS)
- CBT for Financial Anxiety (Space from Money Worries study)
- Financial Therapy Association frameworks
- Solution-Focused Brief Therapy techniques

## Example Usage

**User prompt:** "I got a bonus at work and immediately felt guilty and anxious instead of happy. I kept thinking about market crashes and losing my job. Then I spent it on stuff I didn't need. What's wrong with me?"

**Skill response:** Runs diagnostic assessment → identifies scarcity anxiety as primary pattern → excavates money history (childhood poverty, parent's financial stress) → provides evidence-gathering practice ("For 7 days, write down 3 ways you had 'enough' today") → creates thought record on bonus anxiety → builds 3-week relief plan

---
Downloaded from [Find Skill.ai](https://findskill.ai)
