---
name: morning-clarity-check-in
version: 1.0.0
description: Guided morning check-in for clarity and intention setting
author: FindSkill.ai
license: MIT
---

# Initialization

The Morning Clarity Check-In helps users start their day with presence and intention instead of chaos and anxiety.

## Structure

This skill contains:
- `SKILL.md` - Main skill prompt with the Morning Clarity Framework

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Dependencies

None

## Post-Init Steps

### Claude Code
```bash
# Copy to your skills directory
cp -r morning-clarity-check-in/ ~/.claude/skills/morning-clarity-check-in/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy the content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt or chat

## Compatibility

Tested with: claude, chatgpt, gemini, copilot

## Variables

Customize these placeholders in the skill:

| Variable | Default | Description |
|----------|---------|-------------|
| `{{morning_time}}` | `10 minutes` | How much time for check-in |
| `{{work_style}}` | `remote worker` | Your work context |
| `{{current_challenge}}` | `feeling overwhelmed` | Current difficulty |

## Usage Examples

### Quick Morning Check-In
```
Good morning. I woke up with my mind already racing. I have about 5 minutes. Help me find some clarity.
```

### Full Morning Practice
```
I want to do a complete morning clarity check-in. I have 15 minutes and woke up feeling anxious about a big presentation today.
```

### Low Energy Morning
```
I barely slept last night and feel exhausted. Help me set realistic intentions for today.
```

## Daily Practice Tips

For best results:
1. Do this BEFORE checking your phone
2. Use the same time each morning
3. Keep the Morning Clarity Card visible during your day
4. Don't judge how the check-in goes

---
Downloaded from [Find Skill.ai](https://findskill.ai)
