---
name: negotiation-stance-builder
version: 1.0.0
---

# Initialization

Negotiation Stance Builder is an AI-powered negotiation coach that helps you identify, select, and execute optimal negotiation stances using the Thomas-Kilmann Conflict Mode Instrument framework. It analyzes your situation context (relationship importance, time pressure, power dynamics, BATNA strength) and recommends whether to Compete, Collaborate, Compromise, Avoid, or Accommodate.

## Structure

This skill contains:
- `SKILL.md` - Main skill prompt with comprehensive negotiation stance guidance

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Dependencies

None

## Post-Init Steps

### Claude Code
```bash
cp -r negotiation-stance-builder/ ~/.claude/skills/negotiation-stance-builder/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after the frontmatter (starting from "You are an expert...")
3. Paste into your AI assistant's system prompt or custom instructions

## Compatibility

Tested with: claude, chatgpt, gemini, copilot

## Core Capabilities

| Capability | Description |
|------------|-------------|
| Stance Diagnosis | Analyze context and recommend optimal Thomas-Kilmann stance |
| BATNA Development | Strengthen alternatives and calculate walk-away points |
| ZOPA Analysis | Identify and expand zones of possible agreement |
| Real-Time Pivoting | Mid-negotiation stance transitions with scripts |
| Multi-Party Coordination | Stakeholder mapping and coalition building |
| Emotional Coaching | Manage emotions and de-escalate tension |

## The Five Stances

| Stance | Assertiveness | Cooperativeness | Best When |
|--------|--------------|-----------------|-----------|
| **Competing** | High | Low | Strong leverage, transactional relationship |
| **Collaborating** | High | High | Ongoing relationship, creative solutions needed |
| **Compromising** | Moderate | Moderate | Time pressure, equal power |
| **Avoiding** | Low | Low | Trivial issue, emotions too high |
| **Accommodating** | Low | High | Relationship preservation paramount |

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{negotiation_type}}` | `business_contract` | Category: salary, vendor_contract, merger_acquisition, conflict_resolution, personal_agreement, international_deal |
| `{{relationship_importance}}` | `7` | Scale 1-10 (1=transactional, 10=lifetime partnership) |
| `{{time_pressure}}` | `moderate` | Options: low, moderate, high, critical |
| `{{power_dynamics}}` | `equal` | Options: we_stronger, equal, they_stronger, uncertain |
| `{{batna_strength}}` | `6` | Scale 1-10 (1=no alternatives, 10=excellent walk-away option) |
| `{{emotional_volatility_risk}}` | `moderate` | Options: low, moderate, high |

## Example Usage

```
I'm negotiating a software license renewal. The vendor wants a 30% increase
($45,000/year up from $34,500). My budget ceiling is 10% increase ($37,950 max).
We could switch to a competitor in 3 months if needed. Contract expires in 6 weeks.
The relationship has been good but we're vendor-agnostic.

What negotiation stance should I take?
```

## Key Concepts

- **BATNA** - Best Alternative to Negotiated Agreement (your walk-away option)
- **ZOPA** - Zone of Possible Agreement (overlapping acceptable ranges)
- **Anchoring** - First offer sets psychological reference point
- **Principled Negotiation** - Focus on interests, not positions
- **Logrolling** - Trading issues of differing importance

## Research Sources

- Harvard Negotiation Project - "Getting to Yes"
- Thomas-Kilmann Conflict Mode Instrument
- ASTRA Framework for adaptive negotiation
- PON (Program on Negotiation) research

---
Downloaded from [Find Skill.ai](https://findskill.ai)
