---
name: neighborhood-deep-dive-planner
version: 1.0.0
---

# Initialization

Comprehensive neighborhood research and evaluation skill that combines walkability data, crime statistics, school ratings, local amenities, and community characteristics to help users make informed relocation decisions. Creates comparison scorecards and personalized exploration itineraries.

## Structure

This skill contains:
- `SKILL.md` - Main skill prompt with complete instructions for neighborhood analysis

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Dependencies

None - this is a standalone prompt skill that works with any AI assistant.

## Post-Init Steps

### Claude Code
```bash
cp -r neighborhood-deep-dive-planner/ ~/.claude/skills/neighborhood-deep-dive-planner/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into your AI assistant as a system prompt or initial message

## Compatibility

Tested with: Claude, ChatGPT, Gemini, Copilot

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{neighborhood_name}}` | `Austin, TX - East Austin` | The specific neighborhood, city, or zip code to research |
| `{{research_depth}}` | `comprehensive` | Level of analysis: quick, standard, or comprehensive |
| `{{priority_factors}}` | `walkability, schools, safety` | Ranked list of factors that matter most to the user |
| `{{household_type}}` | `family` | Household composition: single, couple, family, retirees |
| `{{budget_constraint}}` | `moderate` | Housing budget level: tight, moderate, flexible |
| `{{visit_schedule_preference}}` | `flexible` | When user can visit in person: weekend_only, flexible, multi_day |

## Usage Examples

### Example 1: Family Relocating with School Priority
```
I'm considering relocating from Chicago to Austin, TX and have narrowed it
down to three neighborhoods: East Austin, South Austin, and Mueller. We're a
family with two kids (ages 6 and 9), so schools and safety are top priorities,
but we also want walkable access to restaurants and parks. Our budget is
$550-700K. We can visit Austin twice in the next month. Can you create a
comprehensive comparison of these neighborhoods and plan our exploration visits?
```

### Example 2: Young Professional Seeking Walkable Urban
```
I'm a 32-year-old engineer with a job offer at a tech campus in South San Jose.
I need a neighborhood with <45 minute commute, walkable to restaurants and bars,
good for young professionals, and some nightlife. I can only visit for one
weekend before deciding. Help me evaluate my options.
```

### Example 3: Real Estate Investment Analysis
```
I'm looking at three Denver neighborhoods for investment property: RiNo, Five
Points, and Speer. I want to understand the gentrification trajectory,
projected appreciation, displacement risk, and how the business mix is evolving.
Can you analyze these for investment potential?
```

## Core Capabilities

1. **Walkability & Transit Assessment** - Walk Score interpretation, transit analysis, bike infrastructure
2. **Public Safety Analysis** - Crime statistics, trends, safe zones, practical safety tips
3. **School Evaluation** - Ratings, programs, access, public/private options
4. **Amenity Mapping** - Essential services, lifestyle amenities, family facilities
5. **Community Vibe Assessment** - Demographics, social fabric, gentrification stage
6. **Demographic Profiling** - Population, economics, housing market, diversity
7. **Visitation Itinerary Planning** - Optimized exploration routes with observation checklists

## Research Sources

This skill draws on methodologies from:
- Walk Score professional methodology
- CrimeMapping.com crime data
- GreatSchools rating system
- Census demographic data
- Urban planning research on walkability and livability
- Community assessment frameworks

---
Downloaded from [Find Skill.ai](https://findskill.ai)
