---
name: new-year-goal-habit-builder
version: 1.0.0
description: Comprehensive New Year goal and habit system builder using SMART goals and habit stacking
author: FindSkill.ai
license: MIT
---

# Initialization

The New Year Goal & Habit System Builder helps users turn resolutions into lasting change using SMART goals and habit stacking techniques from Atomic Habits.

## Structure

This skill contains:
- `SKILL.md` - Main skill prompt with the Resolution Success Framework

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Dependencies

None

## Post-Init Steps

### Claude Code
```bash
# Copy to your skills directory
cp -r new-year-goal-habit-builder/ ~/.claude/skills/new-year-goal-habit-builder/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy the content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt or chat

## Compatibility

Tested with: claude, chatgpt, gemini, copilot

## Variables

Customize these placeholders in the skill:

| Variable | Default | Description |
|----------|---------|-------------|
| `{{goal_areas}}` | `health and career` | Life areas for goal setting |
| `{{past_resolution_struggle}}` | `lost motivation` | Why past resolutions failed |
| `{{available_time}}` | `30 minutes` | Daily time for new habits |
| `{{accountability_preference}}` | `weekly reviews` | Preferred check-in frequency |

## Usage Examples

### New Year Planning
```
It's December and I want to set up my goals for next year. I want to focus on getting healthier, advancing my career, and reading more. Help me create a system.
```

### Mid-Year Reset
```
I abandoned my New Year resolutions in February. It's July now. Help me restart without the guilt and build something more sustainable.
```

### Single Goal Focus
```
I have one goal: lose 30 pounds by summer. Help me build a complete habit system around this goal.
```

### Troubleshooting
```
I've been tracking my habits for a month but I keep missing my workout goal. Help me figure out why and adjust my system.
```

## Best Used

- **December-January**: Peak New Year planning season
- **Mid-year**: Reset and adjust goals
- **After setbacks**: Restart without judgment
- **Monthly reviews**: Check progress and adjust

---
Downloaded from [Find Skill.ai](https://findskill.ai)
