---
name: org-design-optimizer
version: 1.0.0
---

# Org Design Optimizer - Initialization

An AI skill for organizational design optimization that suggests restructures based on company size, stage, strategy, and culture. Get expert recommendations for team structures, staffing ratios, role architecture, and restructuring roadmaps.

## Overview

This skill transforms AI into an expert organizational design consultant. It helps founders, HR leaders, and executives:

- **Stage-Based Structure Recommendations**: Get appropriate org models for pre-seed through enterprise
- **Size-Appropriate Staffing Ratios**: Calculate optimal team sizes by department
- **Strategic Alignment Mapping**: Align structure to business strategy
- **Restructuring Roadmaps**: Plan phased transitions with change management
- **Role Architecture Design**: Define clear roles, RACI matrices, and decision rights
- **Cross-Functional Team Design**: Structure squads, tribes, chapters, and guilds
- **Org Health Diagnostics**: Assess clarity, alignment, collaboration, culture, capacity

## Package Structure

```
org-design-optimizer/
├── SKILL.md     # Main skill prompt (copy to AI)
└── INIT.md      # This initialization guide
```

## Files to Generate

None required - this is a prompt-only skill.

## Installation

### Claude Code (Recommended)

```bash
# Copy skill to Claude Code skills directory
cp -r org-design-optimizer/ ~/.claude/skills/org-design-optimizer/
```

Then reference in conversations:
```
Use the org-design-optimizer skill to help me restructure my 50-person company.
```

### ChatGPT / Claude Web / Gemini

1. Open `SKILL.md`
2. Copy all content after the YAML frontmatter (after the second `---`)
3. Paste into a new conversation as a system prompt or first message
4. Start describing your organizational challenge

### Custom GPT

1. Create a new GPT at https://chat.openai.com/gpts/editor
2. Paste the SKILL.md content into Instructions
3. Name it "Org Design Optimizer"
4. Configure conversation starters:
   - "Help me structure my 35-person startup"
   - "We need to transition from flat to managed"
   - "Design a squad-based model for our team"
   - "Assess our org health and recommend improvements"

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{company_size}}` | `50` | Total number of employees (1-5000+) |
| `{{company_stage}}` | `growth` | Stage: pre-seed, seed, series_a, series_b, series_c, profitable, scale, enterprise |
| `{{primary_strategy}}` | `growth` | Focus: product_innovation, market_expansion, profitability, consolidation, talent_retention |
| `{{industry}}` | `software` | Industry: software, fintech, healthcare, manufacturing, enterprise_saas, b2c, services, nonprofit |
| `{{culture_priority}}` | `balanced` | Culture: agility, stability, collaboration, individual_achievement, balanced |
| `{{constraint_budget}}` | `unconstrained` | Budget: very_limited, limited, moderate, unconstrained |

## Example Usage

```
I'm a founder of a 35-person B2B SaaS company (Series A, $5M ARR) in the
data analytics space. We're growing 15% MoM and need to hire 15-20 people
in the next 6 months. Right now, we're flat – everyone reports to me (CEO).
My strategy is product-market fit expansion and entering new verticals.
Our culture is very collaborative and agile. I want to introduce managers
without becoming bureaucratic. What organizational structure should I adopt,
and how do I transition from flat to managed? What roles should I hire for first?
```

## Key Capabilities

### 1. Stage-Based Structure Recommendations
Matches org structure to company maturity:
- Pre-seed/Seed (1-15): Flat, founder-driven
- Series A (15-50): Functional with 2-4 leads
- Series B-C (50-250): Hierarchical functional or divisional
- Scale (250-1000): Divisional, matrix, or Spotify model
- Enterprise (1000+): Multi-divisional with governance

### 2. Staffing Ratios by Department
Provides industry-standard ratios:
- HR: 1:25 (small) → 1:150 (enterprise)
- Engineering managers: 5-8 direct reports
- Sales: SDR:AE 1:1-2:1, AE:Manager 6-8:1
- Customer Success: 1:5 (enterprise) → 1:200 (low-touch)

### 3. Restructuring Roadmaps
Five-phase transition planning:
1. Assessment (Weeks 1-2)
2. Design (Weeks 2-4)
3. Communication (Week 4)
4. Execution (Weeks 4-8)
5. Stabilization (Weeks 8-16)

### 4. Role Architecture
Includes templates for:
- Role definition documents
- RACI matrices
- Decision rights frameworks
- Career ladders

### 5. Cross-Functional Team Design
Spotify-inspired models:
- Squads (6-12 cross-functional)
- Tribes (4-12 squads)
- Chapters (skill communities)
- Guilds (interest groups)

## Frameworks Included

- **McKinsey 7S Model**: Strategy, Structure, Systems, Skills, Staff, Style, Shared Values
- **OKR Framework**: Objectives and Key Results for goal cascading
- **RACI Framework**: Responsible, Accountable, Consulted, Informed
- **Spotify Model**: Squads, Tribes, Chapters, Guilds

## Industry Patterns Covered

- Software/SaaS companies
- Professional services (consulting, legal)
- Manufacturing/Enterprise
- Sales-driven organizations
- Nonprofit organizations

## Troubleshooting Guides

The skill includes diagnostic and solution guidance for:
- "Decisions take too long"
- "Teams don't collaborate"
- "We keep hiring but still feel understaffed"
- "Managers are overwhelmed"
- "High attrition of top performers"
- "Acquired company isn't integrating"
- "New structure isn't working"
- "Founders can't let go"

## Research Sources

This skill synthesizes insights from:
- Startup Savant organizational guides
- Functionly Spotify model analysis
- McKinsey 7S framework applications
- SHRM HR staffing ratio benchmarks
- Quantive OKR alignment research

## Related Skills

- Business Model Canvas Generator
- Hiring Decision Validator
- Performance Review Generator
- Onboarding Checklist Creator
- Go-to-Market Strategy Creator

---
Downloaded from [Find Skill.ai](https://findskill.ai)
