---
name: parental-leave-handoff-planner
version: 1.0.0
description: Plan comprehensive coverage for parental leave
author: FindSkill.ai
license: MIT
---

# Initialization

## Overview

This skill helps professionals prepare comprehensive coverage plans for parental leave using the PEACE framework, ensuring smooth handoffs and a clear return-to-work transition.

**Time to initialize**: ~1 minute (prompt-only skill)

## Directory Structure

```
parental-leave-handoff-planner/
├── SKILL.md    # Main skill instructions
└── INIT.md     # This initialization file
```

## Dependencies

None (prompt-only skill)

## What This Skill Covers

### Planning Components
- Pre-leave timeline (8 weeks to departure)
- Task delegation matrix
- Coverage categories (Critical/Defer/Pause)
- Stakeholder communication plan
- Out-of-office templates
- Boundary setting protocols
- Return-to-work phased plan

### Templates Included
- Leave announcement email
- Out-of-office message
- First week back agenda

## Usage Instructions

### For Claude Code

```bash
cp -r parental-leave-handoff-planner/ ~/.claude/skills/parental-leave-handoff-planner/
```

### For Other AI Assistants

1. Open `SKILL.md`
2. Copy content after frontmatter
3. Paste into your AI assistant

## Example Request

```
I'm going on maternity leave for 16 weeks starting in 6 weeks.
I manage a team of 5 and lead our largest client account. My boss
said we're not backfilling, so my work will be split among colleagues.
Help me create a handoff plan that lets me actually take leave.
```

## Compatibility

Tested with: Claude, ChatGPT, Gemini, Copilot

---
Downloaded from [Find Skill.ai](https://findskill.ai)
