---
name: peer-recognition-message-writer
version: 1.0.0
description: Write meaningful peer recognition messages that go beyond generic praise
author: FindSkill.ai
license: MIT
---

# Initialization

## Overview

This skill helps professionals write meaningful peer recognition using the STAR method, creating messages that focus on specific actions and real impact rather than generic corporate praise.

**Time to initialize**: ~1 minute (prompt-only skill)

## Directory Structure

```
peer-recognition-message-writer/
├── SKILL.md    # Main skill instructions
└── INIT.md     # This initialization file
```

## Dependencies

None (prompt-only skill)

## What This Skill Covers

### Recognition Formats
- Slack/Teams public shoutouts
- Award nominations
- Private thank you emails
- Manager visibility notes

### Recognition Scenarios
- Above-and-beyond help
- Consistent excellence
- Cross-team collaboration
- Invisible work
- Mentorship
- Recovery from failure

## Usage Instructions

### For Claude Code

```bash
cp -r peer-recognition-message-writer/ ~/.claude/skills/peer-recognition-message-writer/
```

### For Other AI Assistants

1. Open `SKILL.md`
2. Copy content after frontmatter
3. Paste into your AI assistant

## Example Request

```
A colleague went way above and beyond to help me debug a critical
production issue at 10pm on a Friday. I want to recognize her publicly
in our #kudos Slack channel, but I don't want it to sound generic.
Help me write something genuine.
```

## Compatibility

Tested with: Claude, ChatGPT, Gemini, Copilot

---
Downloaded from [Find Skill.ai](https://findskill.ai)
