---
name: permission-to-spend-framework
version: 1.0.0
---

# Initialization

The Permission to Spend Framework helps high-savers overcome spending guilt and money anxiety through evidence-based financial psychology. Combining 4% rule calculations with CBT reframing techniques, this skill diagnoses the root cause of your spending guilt (scarcity trauma, perfectionism, comparison anxiety, or moral beliefs) and generates personalized permission statements with mathematical proof that you've earned guilt-free spending.

## Structure

This skill contains:
- `SKILL.md` - Main skill prompt with comprehensive instructions for:
  - Financial permission justification with 4% rule calculations
  - Guilt source diagnosis (scarcity trauma, perfectionism, comparison, moral belief)
  - CBT-based cognitive reframing techniques
  - P.A.S.S. method for real-time anxiety response
  - Permission card generation
  - Couples permission framework negotiation
  - 30-day permission recovery challenge

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Dependencies

None

## Post-Init Steps

### Claude Code
```bash
cp -r permission-to-spend-framework/ ~/.claude/skills/permission-to-spend-framework/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after the frontmatter (starting from "You are a Permission to Spend Framework specialist...")
3. Paste into your AI assistant as system instructions or initial prompt

## Compatibility

Tested with: claude, chatgpt, gemini, copilot

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{current_net_worth_usd}}` | `500000` | Total liquid + invested assets for permission calculations |
| `{{annual_expenses_usd}}` | `60000` | Total yearly spending needed for 4% rule basis |
| `{{monthly_guilt_intensity}}` | `7` | Self-rated spending anxiety 1-10 scale |
| `{{primary_guilt_source}}` | `scarcity_trauma` | Root cause: scarcity_trauma, perfectionism, comparison_anxiety, or moral_belief |
| `{{permission_threshold_usd}}` | `5000` | Monthly spending amount that triggers zero guilt |
| `{{recovery_timeline_days}}` | `30` | Duration of structured permission challenge (7, 14, 30, 60, 90) |

## Core Capabilities

1. **Financial Permission Justification** - Generate evidence-based proof showing adequate capacity for guilt-free spending using 4% rule and percentage-based perspective
2. **Guilt Identification & Reframing** - Diagnose guilt source (scarcity trauma, perfectionism, comparison anxiety, moral belief) and apply targeted CBT reframes
3. **Spending Threshold Calculation** - Create personalized permission hierarchy (Micro-Joy, Comfort, Considered, Major, Significant)
4. **Permission Card Generation** - Produce portable permission statements with specific numbers for moment-of-purchase anxiety
5. **P.A.S.S. Anxiety Protocol** - Pause-Assess-Script-Spend method for real-time anxiety de-escalation
6. **Progress Tracking** - Monitor guilt reduction over 30/60/90 days with structured measurement
7. **Couples Framework** - Negotiate permission thresholds for partners with mismatched spending styles

## Example Usage

```
User: "I make $250K/year and have $2.1M saved. I know I should feel secure,
but I still feel anxious buying a $40 coffee. I grew up poor and watched
my parents struggle with money. Can you help me prove to myself I've
earned the right to enjoy this?"

AI Response includes:
- Evidence document showing $84K sustainable spending vs $60K actual
- Guilt diagnosis: Scarcity trauma
- Reframe: "Your hypervigilance protected you during scarcity. You've now
  achieved the security you feared losing."
- Permission card: "My $40 coffee costs 0.002% of my net worth. Enjoying
  abundance doesn't undo my security—it proves I achieved it."
- P.A.S.S. script for moment-of-purchase anxiety
```

## Research Sources

This skill is based on evidence from:
- Twin studies on saving disposition and financial distress (PMC10118204)
- Research on anxiety and money management behavior (Kansas State)
- Meta-analysis of financial self-control strategies (PMC8266115)
- CBT interventions for financial anxiety (PMC9046654)
- 8-factor money attitude model systematic review
- Longitudinal studies on financial assets and mental health

---
Downloaded from [Find Skill.ai](https://findskill.ai)
