---
name: personal-budget-coach
version: 1.0.0
description: AI-powered budget coaching with spending pattern analysis, money script identification, behavioral insights, and personalized savings strategies.
author: FindSkill.ai
license: MIT
---

# Initialization

## Overview

Personal Budget Coach is a prompt-based skill that transforms your AI assistant into a behavioral finance coach. Unlike simple budget calculators, this skill addresses the psychology behind spending patterns and creates sustainable behavior change.

**Time to initialize**: ~1 minute (prompt-only skill)

## What This Skill Does

1. **Identifies Money Scripts**: Analyzes spending behaviors to determine psychological relationship with money (Avoidance, Worship, Status, or Vigilance)

2. **Analyzes Spending Patterns**: Detects temporal, emotional, and category-based spending patterns

3. **Creates Personalized Budgets**: Designs budget systems that work WITH user psychology, not against it

4. **Provides Ongoing Coaching**: Weekly check-ins, accountability, and behavioral guidance

5. **Handles Financial Crises**: Emergency triage protocol for immediate money problems

## Directory Structure

```
personal-budget-coach/
├── SKILL.md          # Main skill instructions
└── INIT.md           # This initialization file
```

## Dependencies

None required. This is a prompt-only skill that works with any AI assistant.

## Files to Generate

None. This skill consists entirely of SKILL.md which contains the coaching framework and prompts.

## Installation

### For Claude Code Users

```bash
# Copy to your skills directory
mkdir -p ~/.claude/skills/personal-budget-coach
cp SKILL.md ~/.claude/skills/personal-budget-coach/
```

### For ChatGPT, Claude Web, Gemini, Copilot

1. Open SKILL.md
2. Copy the content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt, custom instructions, or start of conversation
4. Begin your coaching session

## Quick Start

After loading the skill, start with:

> "I need help with my budget. I make $X/month after taxes. My main expenses are [list expenses]. I struggle with [specific challenge] and want to [goal]."

The AI will:
1. Ask clarifying questions about your financial situation
2. Identify your money personality type
3. Analyze your spending patterns
4. Create a personalized budget
5. Provide ongoing coaching

## Variables

Customize these in your prompts:

| Variable | Options | Description |
|----------|---------|-------------|
| `{{coaching_style}}` | supportive, direct, analytical | How feedback is delivered |
| `{{check_in_frequency}}` | daily, weekly, biweekly, monthly | How often to review |
| `{{focus_area}}` | savings, debt, spending, balance | Primary financial priority |

## Example Sessions

### Initial Assessment
```
User: I make $5,500/month but never have money left. Rent $1,600,
car $380. I spend too much on Amazon and food delivery. Want to
save for a house but keep failing. Stressed about money constantly.

AI: [Conducts behavioral assessment, identifies patterns, creates
personalized budget with specific recommendations]
```

### Weekly Check-In
```
User: Weekly check-in. Stayed under grocery budget but overspent
on dining out by $60.

AI: [Celebrates win, explores dining trigger, suggests adjustment,
sets focus for next week]
```

### Crisis Mode
```
User: Emergency - my car needs $1,200 repair and I only have $400
in savings. Bills due next week.

AI: [Activates triage protocol, prioritizes essentials, identifies
options, creates action plan]
```

## Key Frameworks Used

### Money Scripts (Dr. Brad Klontz)
- Money Avoidance
- Money Worship
- Money Status
- Money Vigilance

### Spending Pattern Categories
- Temporal (when)
- Emotional (why)
- Category leaks (where)

### Budget Frameworks
- 50/30/20 Rule
- Zero-Based Budgeting
- Pay Yourself First
- Envelope System

## Research Sources

This skill incorporates insights from:
- Ramsey Solutions State of Personal Finance 2025
- Financial Planning Association research on money scripts
- Bankrate AI budgeting tool analysis
- Financial Health Network behavioral design research

## Compatibility

Tested and works with:
- Claude (Anthropic)
- ChatGPT (OpenAI)
- Gemini (Google)
- Copilot (Microsoft)
- Any LLM with sufficient context length

## Troubleshooting

**AI gives generic advice**: Provide more specific details about income, expenses, and challenges.

**Budget doesn't feel right**: Ask the AI to identify your money script first, then redesign the budget for your personality type.

**Overwhelmed by complexity**: Request the "simple mode" - two accounts (Bills + Spending) with maximum automation.

**Need crisis help**: Start with "Emergency mode - I need help with an immediate financial problem."

---
Downloaded from [FindSkill.ai](https://findskill.ai)
