---
name: pitch-deck-story-architect
version: 1.0.0
---

# Initialization

Transform raw startup information into compelling investor narratives using proven storytelling frameworks like Hero's Journey and three-act structure. This skill helps founders craft pitch stories that balance emotional resonance with analytical rigor, anticipate investor objections, and customize narratives for different investor types.

## Structure

This skill contains:
- `SKILL.md` - Main skill prompt with comprehensive narrative frameworks, objection handling, and investor customization

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Dependencies

None

## Post-Init Steps

### Claude Code
```bash
cp -r pitch-deck-story-architect/ ~/.claude/skills/pitch-deck-story-architect/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after the frontmatter (starting from "You are an expert Pitch Deck Story Architect...")
3. Paste into your AI assistant's custom instructions or system prompt

## Compatibility

Tested with: claude, chatgpt, gemini, copilot

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{investor_type}}` | `series_a_vc` | Target investor profile (angel_investor, seed_vc, series_a_vc, strategic_investor) |
| `{{narrative_framework}}` | `hero_journey` | Story structure (hero_journey, three_act, problem_solution_impact) |
| `{{problem_specificity_level}}` | `high` | Problem statement depth (high, medium, low) |
| `{{objection_depth}}` | `comprehensive` | Objection handling scope (comprehensive, focused, minimal) |
| `{{audience_familiarity}}` | `low` | Investor familiarity with your market (low, medium, high) |
| `{{visual_style}}` | `minimalist` | Slide design philosophy (minimalist, data_rich, story_heavy) |

## Key Capabilities

1. **Narrative Arc Construction** - Hero's Journey, three-act structure, problem-solution-impact frameworks
2. **Slide Sequencing** - Cognitive psychology-based slide ordering
3. **Objection Anticipation** - 10+ common objections with counter-narratives
4. **Emotional Resonance** - Customer stories, founder origin patterns, vision framing
5. **Investor Customization** - Tailored emphasis for angels, seed VCs, Series A, strategic investors
6. **Problem Statement Crafting** - Specificity framework (WHO/WHAT/WHY/HOW BIG)

## Example Usage

```
"I'm a technical founder of a B2B SaaS startup that helps mid-market e-commerce
companies reduce inventory management time by 80%. We have 12 paying customers,
$25K MRR, and 40% month-over-month growth, but I'm terrible at telling the story.
We're pitching Series A VCs next month. Can you help me structure a narrative arc
that makes our problem clear, positions our solution, proves product-market fit,
addresses market size objections, and ends with a clear $3M ask?"
```

---
Downloaded from [Find Skill.ai](https://findskill.ai)
