---
name: prd-generator
version: 1.0.0
---

# PRD Generator - Initialization

Transform problem statements and user feedback into comprehensive Product Requirements Documents. Generate user personas, feature specs, acceptance criteria, and success metrics in minutes.

## What This Skill Does

The PRD Generator helps Product Managers, Startup Founders, and Business Analysts create professional-grade Product Requirements Documents by:

- Converting problem statements into complete PRD structures
- Synthesizing user feedback into prioritized requirements
- Generating user personas with demographics, goals, and pain points
- Creating user stories with testable acceptance criteria
- Defining success metrics with baselines and targets
- Documenting non-functional requirements (performance, security, scalability)
- Identifying risks and constraints

## Package Structure

```
prd-generator/
├── SKILL.md     # Main skill prompt (copy to AI assistant)
└── INIT.md      # This file
```

## Files to Generate

None required - this is a prompt-only skill.

## Installation

### Claude Code

```bash
cp -r prd-generator/ ~/.claude/skills/prd-generator/
```

Then reference in conversations:

```
Use the prd-generator skill to create a PRD for [your problem statement]
```

### ChatGPT / GPT-4

1. Open `SKILL.md`
2. Copy all content after the `---` frontmatter separator
3. Paste into ChatGPT as your first message or create a Custom GPT

### Claude.ai (Web)

1. Open `SKILL.md`
2. Copy all content after the frontmatter
3. Start a new conversation and paste as system context
4. Or create a Claude Project with this as project instructions

### Gemini

1. Open `SKILL.md`
2. Copy all content after the frontmatter
3. Paste into Gemini as initial context

### GitHub Copilot Chat

1. Open `SKILL.md` in your editor
2. Select all content
3. Use `/explain` or reference the file in Copilot Chat

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `product_type` | `software_application` | Category of product: mobile_app, saas_platform, api, hardware, service |
| `target_audience_level` | `intermediate` | PRD detail level: technical (engineers), intermediate (cross-functional), executive (C-level) |
| `prd_length` | `standard` | Output length: brief (4-6 pages), standard (8-12 pages), comprehensive (15-20 pages) |
| `include_timeline` | `true` | Whether to include release phases and sprint planning |
| `competitive_analysis` | `false` | Whether to include competitor feature matrix |
| `constraint_type` | `standard` | Constraint focus: standard, startup, enterprise, regulated |

## Quick Start Examples

### Example 1: Startup MVP PRD

```
Problem: Freelance designers spend 5-10 hours per week managing invoicing and
client follow-ups. They need a simple invoicing + CRM tool for service freelancers.

Constraints:
- Budget: MVP in 12 weeks with 2-3 engineers
- Must-have: Invoice generation, payment tracking, client database

Generate a standard PRD with personas, features, and 18-month roadmap.
```

### Example 2: User Feedback Synthesis

```
I have 50 pieces of user feedback from:
- 20 support emails about late payment issues
- 15 survey responses requesting recurring billing
- 10 interview transcripts mentioning Stripe integration pain
- 5 NPS comments wanting mobile invoice creation

Analyze this feedback and generate a prioritized feature list with traceability.
```

### Example 3: Enterprise SaaS PRD

```
We're building a data analytics platform for fintech companies.

Requirements:
- SOC 2, GDPR compliance
- Real-time dashboards
- 100K concurrent users
- API-first architecture

Generate a comprehensive PRD with technical specifications and compliance requirements.
```

## PRD Sections Generated

The skill produces PRDs with these sections:

1. **Executive Summary** - One-paragraph product overview
2. **Problem Statement** - User, design, and business problems
3. **User Personas** - 2-4 detailed personas with quotes
4. **User Stories** - Stories with acceptance criteria
5. **Functional Requirements** - Features organized by area
6. **Non-Functional Requirements** - Performance, security, scalability
7. **Success Metrics** - 8-12 KPIs with baselines and targets
8. **Out of Scope** - Explicit exclusions to prevent scope creep
9. **Constraints & Assumptions** - Technical, business, regulatory
10. **Risks & Mitigations** - Risk register with contingencies
11. **Timeline & Roadmap** - Phased release plan (optional)

## Frameworks Used

- **EARS Syntax** - Precise, testable requirement statements
- **MoSCoW** - Must/Should/Could/Won't prioritization
- **RICE Scoring** - Reach x Impact x Confidence / Effort
- **Three Problem Types** - User, Design, and Business problems

## Related Skills

Pair this skill with:

- **Feature Prioritization Framework** - RICE/MoSCoW for ranking features
- **Business Model Canvas Generator** - Define business model before PRD
- **Competitive Analysis Framework** - Research competitors for positioning
- **OKR/KPI Goal-Setter** - Align success metrics with company OKRs

## Tips for Best Results

1. **Provide context** - The more detail in your problem statement, the better the PRD
2. **Specify constraints** - Budget, timeline, team size help scope appropriately
3. **Share existing research** - User feedback, personas, or competitive data
4. **Choose appropriate length** - Use "brief" for MVPs, "comprehensive" for enterprise
5. **Iterate** - Request revisions on specific sections as needed

## Troubleshooting

**PRD is too generic**: Provide more specific problem context and user details

**Missing technical depth**: Set `target_audience_level` to "technical"

**Need compliance focus**: Set `constraint_type` to "regulated" or "enterprise"

**Too many features**: Ask to apply MoSCoW or RICE prioritization

---
Downloaded from [Find Skill.ai](https://findskill.ai)
